/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.gthandler.nameRemover;

import com.dreammaster.gthandler.gui.CoreMod_UITextures;
import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.common.items.ItemIntegratedCircuit;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class NameRemover
extends MTEBasicMachine {
    private static final FallbackableUITexture progressBarTexture = GTUITextures.fallbackableProgressbar((String)"name_remover", (UITexture)CoreMod_UITextures.PROGRESSBAR_NAME_REMOVER);

    public NameRemover(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "Can fix GT items with broken NBT data, will erase everything!", 2, 1, new ITexture[]{new GTRenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER_ACTIVE), new GTRenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER), new GTRenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE), new GTRenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER), new GTRenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER_ACTIVE), new GTRenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER), new GTRenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER_ACTIVE), new GTRenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER)});
    }

    public NameRemover(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 2, 1);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new NameRemover(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public int checkRecipe() {
        if (this.getInputAt(0) == null) {
            return 0;
        }
        ItemStack output = this.getInputAt(0).func_77946_l();
        NBTTagCompound nbt = output.func_77978_p();
        if (nbt != null) {
            int circuitSetting = 0;
            ItemStack circuit = this.getInputAt(1);
            if (circuit != null && circuit.func_77973_b() instanceof ItemIntegratedCircuit) {
                circuitSetting = circuit.func_77960_j();
            }
            boolean removeName = false;
            boolean removeDisassembly = false;
            boolean removeColor = false;
            boolean removeRepair = false;
            boolean removeDye = false;
            boolean removeSpray = false;
            boolean removeCovers = false;
            switch (circuitSetting) {
                case 1: {
                    removeName = true;
                    break;
                }
                case 2: {
                    removeDisassembly = true;
                    break;
                }
                case 3: {
                    removeColor = true;
                    break;
                }
                case 4: {
                    removeRepair = true;
                    break;
                }
                case 5: {
                    removeDye = true;
                    break;
                }
                case 6: {
                    removeSpray = true;
                    break;
                }
                case 24: {
                    removeCovers = true;
                }
                default: {
                    removeName = true;
                    removeDisassembly = true;
                    removeColor = true;
                    removeRepair = true;
                    removeDye = true;
                    removeSpray = true;
                }
            }
            if (removeName && nbt.func_74764_b("display")) {
                nbt.func_74775_l("display").func_82580_o("Name");
                if (nbt.func_74775_l("display").func_82582_d()) {
                    nbt.func_82580_o("display");
                }
            }
            if (removeDisassembly) {
                NameRemover.removeTag(nbt, "GT.CraftingComponents");
            }
            if (removeColor) {
                NameRemover.removeTag(nbt, "color");
            }
            if (removeRepair) {
                NameRemover.removeTag(nbt, "RepairCost");
            }
            if (removeDye && nbt.func_74764_b("display")) {
                nbt.func_74775_l("display").func_82580_o("color");
                if (nbt.func_74775_l("display").func_82582_d()) {
                    nbt.func_82580_o("display");
                }
            }
            if (removeSpray) {
                NameRemover.removeTag(nbt, "mColor");
            }
            NameRemover.removeTag(nbt, "mTargetStackSize");
            NameRemover.removeTag(nbt, "mOutputFluid");
            NameRemover.removeTag(nbt, "mVoidOverflow");
            NameRemover.removeTag(nbt, "mVoidFluidFull");
            NameRemover.removeTag(nbt, "mLockFluid");
            NameRemover.removeTag(nbt, "lockedFluidName");
            NameRemover.removeTag(nbt, "mAllowInputFromOutputSide");
            NameRemover.removeTag(nbt, "mItemsPerSide");
            NameRemover.removeTag(nbt, "radiusConfig");
            NameRemover.removeTag(nbt, "mDisallowRetract");
            NameRemover.removeTag(nbt, "mStrongRedstone");
            if (removeCovers) {
                NameRemover.removeTag(nbt, "mMuffler");
                NameRemover.removeTag(nbt, "mLockUpgrade");
                NameRemover.removeTag(nbt, "mCoverSides");
                NameRemover.removeTag(nbt, "gt.covers");
                for (String key : CoverableTileEntity.COVER_DATA_NBT_KEYS) {
                    NameRemover.removeTag(nbt, key);
                }
            }
            if (nbt.func_82582_d()) {
                output.func_77982_d(null);
            }
        }
        if (this.canOutput(new ItemStack[]{output})) {
            this.getInputAt((int)0).field_77994_a = 0;
            this.mEUt = 0;
            this.mMaxProgresstime = 20;
            this.mOutputItems[0] = output;
            return 2;
        }
        return 0;
    }

    private static void removeTag(NBTTagCompound nbt, String key) {
        if (nbt.func_74764_b(key)) {
            nbt.func_82580_o(key);
        }
    }

    public String[] getDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("Removes various NBT tags as well as covers.");
        description.add(" ");
        description.add(EnumChatFormatting.UNDERLINE + "First Slot" + EnumChatFormatting.RESET);
        description.add("The item you want to strip of NBT");
        description.add(" ");
        description.add(EnumChatFormatting.UNDERLINE + "Second Slot" + EnumChatFormatting.RESET);
        description.add("One of the following circuits:");
        description.add(EnumChatFormatting.BOLD + "Circuit 1:" + EnumChatFormatting.RESET + "  Attempt to fix broken ores by removing the Display Name tag");
        description.add(EnumChatFormatting.BOLD + "Circuit 3:" + EnumChatFormatting.RESET + "  Remove Railcraft stacking tag");
        description.add(EnumChatFormatting.BOLD + "Circuit 4:" + EnumChatFormatting.RESET + "  Remove Anvil repair tag");
        description.add(EnumChatFormatting.BOLD + "Circuit 5:" + EnumChatFormatting.RESET + "  Remove Dye from Leather armor");
        description.add(EnumChatFormatting.BOLD + "Circuit 6:" + EnumChatFormatting.RESET + "  Remove Spray color from GT items");
        description.add(EnumChatFormatting.BOLD + "Circuit 24:" + EnumChatFormatting.RESET + "  Remove everything including covers. Be careful you won't recover the covers!");
        description.add(" ");
        description.add(EnumChatFormatting.BOLD + "No Circuit:" + EnumChatFormatting.RESET + " Remove everything except covers");
        return description.toArray(new String[0]);
    }

    public boolean isElectric() {
        return false;
    }

    public long maxEUStore() {
        return 0L;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public long maxAmperesIn() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 0L;
    }

    protected BasicUIProperties getUIProperties() {
        return super.getUIProperties().toBuilder().progressBarTexture(progressBarTexture).build();
    }
}

