/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.proxy.Proxies;
import forestry.core.utils.vect.IVect;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.Crop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CropBasicAgriCraft
extends Crop {
    private final Block block;
    private final int meta;

    public CropBasicAgriCraft(World world, Block block, int meta, Vect position) {
        super(world, position);
        this.block = block;
        this.meta = meta;
    }

    @Override
    protected boolean isCrop(IVect pos) {
        return this.getBlock(pos) == this.block && this.getBlockMeta(pos) == this.meta;
    }

    @Override
    protected Collection<ItemStack> harvestBlock(IVect pos) {
        ArrayList harvest = this.block.getDrops(this.world, pos.getX(), pos.getY(), pos.getZ(), this.meta, 0);
        if (harvest.size() > 1) {
            harvest.remove(1);
        }
        harvest.remove(0);
        Proxies.common.addBlockDestroyEffects(this.world, pos.getX(), pos.getY(), pos.getZ(), Blocks.field_150440_ba, 0);
        this.world.func_72921_c(pos.getX(), pos.getY(), pos.getZ(), 0, 2);
        harvest.removeAll(Collections.singleton(null));
        return harvest;
    }

    public String toString() {
        return String.format("CropBasicAgriCraft [ position: [ %s ]; block: %s; meta: %s ]", this.position.toString(), this.block.func_149739_a(), this.meta);
    }
}

