/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class EventHandlerApiculture {
    @SubscribeEvent
    public void addFrameTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.itemStack;
        if (itemStack != null && itemStack.func_77973_b() instanceof IHiveFrame) {
            IHiveFrame frame = (IHiveFrame)itemStack.func_77973_b();
            IBeeModifier modifier = frame.getBeeModifier();
            List tooltip = event.toolTip;
            if (!Proxies.common.isShiftDown()) {
                tooltip.add(EnumChatFormatting.ITALIC + "<" + StringUtil.localize("gui.tooltip.tmi") + ">");
            } else if (frame.getFrameTooltip() != null) {
                tooltip.addAll(frame.getFrameTooltip());
            } else {
                int durability = itemStack.func_77958_k();
                tooltip.add(StringUtil.localize("frame.tooltip.durability") + EventHandlerApiculture.getDurabilityFormatted(durability));
                float territory = modifier.getTerritoryModifier(null, 1.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.territory") + EventHandlerApiculture.getModifierFormatted(territory, false, false));
                float mutation = modifier.getMutationModifier(null, null, 1.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.mutationRate") + EventHandlerApiculture.getModifierFormatted(mutation, false, false));
                float lifespan = modifier.getLifespanModifier(null, null, 1.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.lifespan") + EventHandlerApiculture.getModifierFormatted(lifespan, false, true));
                float production = modifier.getProductionModifier(null, 0.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.production") + EventHandlerApiculture.getModifierFormatted(production, true, false));
                float flowering = modifier.getFloweringModifier(null, 1.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.flowering") + EventHandlerApiculture.getModifierFormatted(flowering, false, false));
                float decay = modifier.getGeneticDecay(null, 1.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.geneticDecay") + EventHandlerApiculture.getModifierFormatted(decay, false, true));
            }
        }
    }

    private static String getDurabilityFormatted(int durability) {
        EnumChatFormatting color = durability < 100 ? EnumChatFormatting.DARK_RED : (durability < 200 ? EnumChatFormatting.RED : (durability < 250 ? EnumChatFormatting.GOLD : (durability < 750 ? EnumChatFormatting.GREEN : EnumChatFormatting.AQUA)));
        return color + " " + durability;
    }

    private static String getModifierFormatted(float value, boolean additive, boolean undesireable) {
        float lo_threshold = 0.5f;
        float mid_threshold = 1.0f;
        float hi_threshold = 2.0f;
        float discriminant = value;
        if (additive) {
            lo_threshold = -1.0f;
            mid_threshold = 0.0f;
            hi_threshold = 2.0f;
            if (undesireable) {
                discriminant = -value;
            }
        } else if (undesireable) {
            discriminant = 1.0f / value;
        }
        EnumChatFormatting color = discriminant <= lo_threshold ? EnumChatFormatting.DARK_RED : (discriminant < mid_threshold ? EnumChatFormatting.RED : (discriminant == mid_threshold ? EnumChatFormatting.GOLD : (discriminant <= hi_threshold ? EnumChatFormatting.GREEN : EnumChatFormatting.AQUA)));
        String formatted = color.toString();
        formatted = !additive ? formatted + " x" : (value >= 0.0f ? formatted + " +" : formatted + " ");
        if (value == (float)((long)value)) {
            return formatted + (long)value;
        }
        return formatted + value;
    }
}

