/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderzoo.EnderZoo;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.IEnderZooMob;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.vec.VecUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EntityEnderminy
extends EntityMob
implements IEnderZooMob {
    public static String NAME = "enderzoo.Enderminy";
    public static final int EGG_BG_COL = 2581069;
    public static final int EGG_FG_COL = 0x212121;
    private static final int MAX_RND_TP_DISTANCE = 32;
    private static final int SCREAMING_INDEX = 20;
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291B0");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", 6.2, 0).func_111168_a(false);
    private int teleportDelay;
    private int stareTimer;
    private Entity lastEntityToAttack;
    private boolean isAggressive;
    private boolean attackIfLookingAtPlayer = Config.enderminyAttacksPlayerOnSight;
    private boolean attackCreepers = Config.enderminyAttacksCreepers;
    private boolean groupAgroEnabled = Config.enderminyGroupAgro;
    private final ClosestEntityComparator closestEntityComparator = new ClosestEntityComparator();

    public EntityEnderminy(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.725f);
        this.field_70138_W = 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.01f;
    }

    protected boolean func_70814_o() {
        return Config.enderminySpawnInLitAreas ? true : super.func_70814_o();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        MobInfo.ENDERMINY.applyAttributes((EntityLivingBase)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)new Byte(0));
    }

    public boolean func_70601_bi() {
        boolean passedGrassCheck = true;
        if (Config.enderminySpawnOnlyOnGrass) {
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            passedGrassCheck = this.field_70170_p.func_147439_a(i, (j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b)) - 1, k = MathHelper.func_76128_c((double)this.field_70161_v)) == Blocks.field_150349_c;
        }
        return passedGrassCheck && this.field_70163_u > (double)Config.enderminyMinSpawnY && super.func_70601_bi();
    }

    protected Entity func_70782_k() {
        int range;
        AxisAlignedBB bb;
        List creepers;
        EntityPlayer entityplayer;
        if (this.attackIfLookingAtPlayer && (entityplayer = this.field_70170_p.func_72856_b((Entity)this, 64.0)) != null) {
            if (this.shouldAttackPlayer(entityplayer)) {
                this.isAggressive = true;
                if (this.stareTimer == 0) {
                    this.field_70170_p.func_72908_a(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, "mob.endermen.stare", 1.0f, 1.0f);
                }
                if (this.stareTimer++ == 5) {
                    this.stareTimer = 0;
                    this.setScreaming(true);
                    return entityplayer;
                }
            } else {
                this.stareTimer = 0;
            }
        }
        if (this.attackCreepers && (creepers = this.field_70170_p.func_72872_a(EntityCreeper.class, bb = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)(range = 16)), (double)(this.field_70163_u - (double)range), (double)(this.field_70161_v - (double)range), (double)(this.field_70165_t + (double)range), (double)(this.field_70163_u + (double)range), (double)(this.field_70161_v + (double)range)))) != null && !creepers.isEmpty()) {
            Collections.sort(creepers, this.closestEntityComparator);
            for (EntityCreeper creeper : creepers) {
                if (!creeper.func_70685_l((Entity)this)) continue;
                return creeper;
            }
        }
        return null;
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.field_70460_b[3];
        if (itemstack != null && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3 relativePlayerEyePos = Vec3.func_72443_a((double)(this.field_70165_t - player.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e())), (double)(this.field_70161_v - player.field_70161_v));
        double distance = relativePlayerEyePos.func_72433_c();
        relativePlayerEyePos = relativePlayerEyePos.func_72432_b();
        Vec3 lookVec = this.func_70676_i(1.0f).func_72432_b();
        double dotTangent = -lookVec.func_72430_b(relativePlayerEyePos);
        return dotTangent > 1.0 - 0.025 / distance;
    }

    public void func_70636_d() {
        if (this.lastEntityToAttack != this.field_70789_a) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(attackingSpeedBoostModifier);
            if (this.field_70789_a != null) {
                iattributeinstance.func_111121_a(attackingSpeedBoostModifier);
            }
        }
        this.lastEntityToAttack = this.field_70789_a;
        for (int k = 0; k < 2; ++k) {
            this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
        if (this.func_70027_ad() || this.func_70090_H()) {
            this.field_70789_a = null;
            this.setScreaming(false);
            this.isAggressive = false;
            this.teleportRandomly();
        }
        if (this.isScreaming() && !this.isAggressive && this.field_70146_Z.nextInt(100) == 0) {
            this.setScreaming(false);
        }
        this.field_70703_bu = false;
        if (this.field_70789_a != null) {
            this.func_70625_a(this.field_70789_a, 100.0f, 100.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70789_a != null) {
                if (this.field_70789_a.func_70068_e((Entity)this) > 256.0 && this.teleportDelay++ >= 30 && this.teleportToEntity(this.field_70789_a)) {
                    this.teleportDelay = 0;
                }
            } else {
                this.setScreaming(false);
                this.teleportDelay = 0;
            }
        }
        super.func_70636_d();
    }

    protected boolean teleportRandomly(int distance) {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)distance;
        double d1 = this.field_70163_u + (double)this.field_70146_Z.nextInt(distance + 1) - (double)(distance / 2);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)distance;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportRandomly() {
        return this.teleportRandomly(32);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - p_70816_1_.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e()), (double)(this.field_70161_v - p_70816_1_.field_70161_v));
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = event.targetX;
        this.field_70163_u = event.targetY;
        this.field_70161_v = event.targetZ;
        int xInt = MathHelper.func_76128_c((double)this.field_70165_t);
        int yInt = MathHelper.func_76128_c((double)this.field_70163_u);
        int zInt = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean flag = false;
        if (this.field_70170_p.func_72899_e(xInt, yInt, zInt)) {
            boolean foundGround = false;
            while (!foundGround && yInt > 0) {
                Block block = this.field_70170_p.func_147439_a(xInt, yInt - 1, zInt);
                if (block.func_149688_o().func_76230_c()) {
                    foundGround = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --yInt;
            }
            if (foundGround) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    protected String func_70639_aQ() {
        return this.isScreaming() ? "mob.endermen.scream" : "mob.endermen.idle";
    }

    protected String func_70621_aR() {
        return "mob.endermen.hit";
    }

    protected String func_70673_aS() {
        return "mob.endermen.death";
    }

    protected Item func_146068_u() {
        return Items.field_151079_bi;
    }

    protected void func_70628_a(boolean hitByPlayer, int looting) {
        Item item = this.func_146068_u();
        if (item != null) {
            int numItems = this.field_70146_Z.nextInt(2 + looting);
            for (int i = 0; i < numItems; ++i) {
                if ((double)this.field_70146_Z.nextFloat() <= 0.5) {
                    this.func_145779_a(EnderZoo.itemEnderFragment, 1);
                }
                this.func_145779_a(item, 1);
            }
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float p_70097_2_) {
        if (this.func_85032_ar()) {
            return false;
        }
        this.setScreaming(true);
        if (damageSource instanceof EntityDamageSourceIndirect) {
            this.isAggressive = false;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return super.func_70097_a(damageSource, p_70097_2_);
        }
        boolean res = super.func_70097_a(damageSource, p_70097_2_);
        if (damageSource instanceof EntityDamageSource && damageSource.func_76346_g() instanceof EntityPlayer && this.func_110143_aJ() > 0.0f) {
            this.isAggressive = true;
            if (this.field_70146_Z.nextInt(3) == 0) {
                for (int i = 0; i < 64; ++i) {
                    if (!this.teleportRandomly(16)) continue;
                    this.field_70789_a = damageSource.func_76346_g();
                    this.doGroupArgo();
                    return true;
                }
            }
        }
        if (res) {
            this.doGroupArgo();
        }
        return res;
    }

    private void doGroupArgo() {
        if (!this.groupAgroEnabled) {
            return;
        }
        if (!(this.field_70789_a instanceof EntityPlayer)) {
            return;
        }
        int range = 16;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)range), (double)(this.field_70163_u - (double)range), (double)(this.field_70161_v - (double)range), (double)(this.field_70165_t + (double)range), (double)(this.field_70163_u + (double)range), (double)(this.field_70161_v + (double)range));
        List minies = this.field_70170_p.func_72872_a(EntityEnderminy.class, bb);
        if (minies != null && !minies.isEmpty()) {
            for (EntityEnderminy miny : minies) {
                if (miny.field_70789_a != null) continue;
                miny.field_70789_a = this.field_70789_a;
            }
        }
    }

    public boolean isScreaming() {
        return this.field_70180_af.func_75683_a(20) > 0;
    }

    public void setScreaming(boolean p_70819_1_) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(p_70819_1_ ? 1 : 0)));
    }

    public double distanceSquared(double x, double y, double z, Vec3 v2) {
        double dx = x - v2.field_72450_a;
        double dy = y - v2.field_72448_b;
        double dz = z - v2.field_72449_c;
        return dx * dx + dy * dy + dz * dz;
    }

    private final class ClosestEntityComparator
    implements Comparator<EntityCreeper> {
        Vec3 pos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);

        private ClosestEntityComparator() {
        }

        @Override
        public int compare(EntityCreeper o1, EntityCreeper o2) {
            VecUtil.set(this.pos, EntityEnderminy.this.field_70165_t, EntityEnderminy.this.field_70163_u, EntityEnderminy.this.field_70161_v);
            double d1 = EntityEnderminy.this.distanceSquared(o1.field_70165_t, o1.field_70163_u, o1.field_70161_v, this.pos);
            double d2 = EntityEnderminy.this.distanceSquared(o2.field_70165_t, o2.field_70163_u, o2.field_70161_v, this.pos);
            return Double.compare(d1, d2);
        }
    }
}

