/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import com.enderio.core.common.util.PlayerUtil;
import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.Log;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.UsernameCache;

public class UserIdent {
    private static final String NONE_MARKER = "none";
    @Nullable
    private final UUID uuid;
    @Nonnull
    private final UUID uuid_offline;
    @Nonnull
    private final String playerName;
    @Nonnull
    public static final Nobody nobody = new Nobody();

    @Nonnull
    public String getPlayerName() {
        String lastKnownName;
        if (this.uuid != null && (lastKnownName = UsernameCache.getLastKnownUsername((UUID)this.uuid)) != null) {
            return lastKnownName;
        }
        return this.playerName;
    }

    public UUID getUUID() {
        return this.uuid != null ? this.uuid : this.uuid_offline;
    }

    public String getUUIDString() {
        return this.uuid != null ? this.uuid.toString() : NONE_MARKER;
    }

    @Nonnull
    public static UserIdent create(@Nullable UUID uuid, @Nullable String playerName) {
        if (uuid != null) {
            String lastKnownName;
            if (nobody.equals(uuid)) {
                return nobody;
            }
            if (playerName != null && (lastKnownName = UsernameCache.getLastKnownUsername((UUID)uuid)) != null && !lastKnownName.equals(playerName)) {
                Log.warn("The user with the UUID " + uuid + " changed name from '" + playerName + "' to '" + lastKnownName + "'");
                return new UserIdent(uuid, lastKnownName);
            }
            return new UserIdent(uuid, playerName);
        }
        if (playerName != null) {
            return new UserIdent(null, playerName);
        }
        return nobody;
    }

    @Nonnull
    public static UserIdent create(@Nonnull String suuid, @Nullable String playerName) {
        if (NONE_MARKER.equals(suuid)) {
            return new UserIdent(null, playerName);
        }
        try {
            UUID uuid = UUID.fromString(suuid);
            if (nobody.equals(uuid)) {
                return nobody;
            }
            return UserIdent.create(uuid, playerName);
        }
        catch (IllegalArgumentException e) {
            return nobody;
        }
    }

    @Nonnull
    public static UserIdent create(@Nullable String legacyData) {
        UUID uuid = PlayerUtil.getPlayerUIDUnstable((String)legacyData);
        if (uuid != null) {
            return new UserIdent(uuid, legacyData);
        }
        if (legacyData != null) {
            return new UserIdent(null, legacyData);
        }
        return nobody;
    }

    @Nonnull
    public static UserIdent create(@Nullable GameProfile gameProfile) {
        if (gameProfile != null && (gameProfile.getId() != null || gameProfile.getName() != null)) {
            if (gameProfile.getId() != null && gameProfile.getName() != null && gameProfile.getId().equals(UserIdent.offlineUUID(gameProfile.getName()))) {
                return new UserIdent(null, gameProfile.getName());
            }
            return new UserIdent(gameProfile.getId(), gameProfile.getName());
        }
        return nobody;
    }

    @Nonnull
    private static UUID offlineUUID(String playerName) {
        UUID result = UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes(Charsets.UTF_8));
        return result != null ? result : new UUID(-1L, -1L);
    }

    private UserIdent(UUID uuid, String playerName) {
        this.uuid = uuid;
        this.uuid_offline = UserIdent.offlineUUID(playerName);
        this.playerName = playerName != null ? playerName : "[" + uuid + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.playerName.hashCode();
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UserIdent) {
            UserIdent other = (UserIdent)obj;
            if (this.uuid != null && other.uuid != null) {
                return this.uuid.equals(other.uuid);
            }
            return this.uuid_offline.equals(other.uuid_offline);
        }
        if (obj instanceof GameProfile) {
            GameProfile other = (GameProfile)obj;
            UUID other_uuid = other.getId();
            if (this.uuid != null && other_uuid != null) {
                return this.uuid.equals(other_uuid);
            }
            UUID uuid_offline_other = UserIdent.offlineUUID(other.getName());
            return uuid_offline_other.equals(this.uuid) || this.uuid_offline.equals(uuid_offline_other);
        }
        if (obj instanceof UUID) {
            return obj.equals(this.uuid) || obj.equals(this.uuid_offline);
        }
        return false;
    }

    public void saveToNbt(NBTTagCompound nbt, String prefix) {
        if (this.uuid != null) {
            nbt.func_74778_a(prefix + ".uuid", this.uuid.toString());
        }
        nbt.func_74778_a(prefix + ".login", this.playerName);
    }

    public static boolean existsInNbt(NBTTagCompound nbt, String prefix) {
        return nbt.func_74764_b(prefix + ".uuid") || nbt.func_74764_b(prefix + ".login");
    }

    @Nonnull
    public static UserIdent readfromNbt(NBTTagCompound nbt, String prefix) {
        String suuid = nbt.func_74779_i(prefix + ".uuid");
        String login = nbt.func_74779_i(prefix + ".login");
        if ("nobody".equals(suuid)) {
            return nobody;
        }
        try {
            UUID uuid = UUID.fromString(suuid);
            return UserIdent.create(uuid, login);
        }
        catch (IllegalArgumentException e) {
            if (login != null && !login.isEmpty()) {
                return new UserIdent(null, login);
            }
            return nobody;
        }
    }

    public String toString() {
        return "User [uuid=" + (this.uuid != null ? this.uuid : "(unknown)") + ", name=" + this.playerName + "]";
    }

    private static class Nobody
    extends UserIdent {
        private static final String NOBODY_MARKER = "nobody";

        private Nobody() {
            super(null, "[unknown player]");
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public void saveToNbt(NBTTagCompound nbt, String prefix) {
            nbt.func_74778_a(prefix + ".uuid", NOBODY_MARKER);
        }
    }
}

