/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gas;

import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.gas.AbstractGasTankConduit;
import crazypants.enderio.conduit.gas.IGasConduit;
import mekanism.api.gas.GasStack;

public class AbstractGasTankConduitNetwork<T extends AbstractGasTankConduit>
extends AbstractConduitNetwork<IGasConduit, T> {
    protected GasStack gasType;

    protected AbstractGasTankConduitNetwork(Class<T> cl) {
        super(cl, IGasConduit.class);
    }

    public GasStack getGasType() {
        return this.gasType;
    }

    @Override
    public void addConduit(T con) {
        super.addConduit(con);
        ((AbstractGasTankConduit)con).setGasType(this.gasType);
    }

    public boolean setGasType(GasStack newType) {
        if (this.gasType != null && this.gasType.isGasEqual(newType)) {
            return false;
        }
        if (newType != null) {
            this.gasType = newType.copy();
            this.gasType.amount = 0;
        } else {
            this.gasType = null;
        }
        for (AbstractGasTankConduit conduit : this.conduits) {
            conduit.setGasType(this.gasType);
        }
        return true;
    }

    public boolean canAcceptGas(GasStack acceptable) {
        return AbstractGasTankConduitNetwork.areGassCompatable(this.gasType, acceptable);
    }

    public static boolean areGassCompatable(GasStack a, GasStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.isGasEqual(b);
    }

    public int getTotalVolume() {
        int totalVolume = 0;
        for (AbstractGasTankConduit con : this.conduits) {
            totalVolume += con.getTank().getStored();
        }
        return totalVolume;
    }
}

