/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.natura.nether;

import biomesoplenty.api.content.BOPCBlocks;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicNetherBerryCrop;
import ic2.api.crops.ICropTile;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class BasicNetherShroomCrop
extends BasicNetherBerryCrop {
    private final String name;
    private final ShroomType shroomType;

    public BasicNetherShroomCrop(String color) {
        this.name = color.equals("Purple") || color.equals("Blue") || color.equals("Green") ? color + " Glowshroom" : "Glowshroom";
        this.shroomType = color.contains("Blue") ? ShroomType.Blue : (color.contains("Green") ? ShroomType.Green : (color.contains("Purple") ? ShroomType.Purple : ShroomType.Other));
    }

    @Override
    public int tier() {
        return 3;
    }

    public String name() {
        return this.name;
    }

    public String[] attributes() {
        return new String[]{"Food", "Mushroom", "Ingredient", "Nether"};
    }

    @Override
    public int stat(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    @Override
    public int maxSize() {
        return 2;
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 1;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= this.maxSize();
    }

    @Override
    public int growthDuration(ICropTile crop) {
        return ConfigValues.debug ? 1 : 600;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < this.maxSize();
    }

    public ItemStack getGain(ICropTile crop) {
        ItemStack itemStack;
        switch (this.shroomType) {
            case Blue: {
                itemStack = new ItemStack((Block)NContent.glowshroom, 1, 2);
                break;
            }
            case Green: {
                itemStack = new ItemStack((Block)NContent.glowshroom, 1, 0);
                break;
            }
            case Purple: {
                itemStack = new ItemStack((Block)NContent.glowshroom, 1, 1);
                break;
            }
            default: {
                itemStack = new ItemStack(BOPCBlocks.mushrooms, 1, 3);
            }
        }
        return itemStack;
    }

    @Override
    public ItemStack getDisplayItem() {
        ItemStack itemStack;
        switch (this.shroomType) {
            case Blue: {
                itemStack = new ItemStack((Block)NContent.glowshroom, 1, 2);
                break;
            }
            case Green: {
                itemStack = new ItemStack((Block)NContent.glowshroom, 1, 0);
                break;
            }
            case Purple: {
                itemStack = new ItemStack((Block)NContent.glowshroom, 1, 1);
                break;
            }
            default: {
                itemStack = new ItemStack(BOPCBlocks.mushrooms, 1, 3);
            }
        }
        return itemStack;
    }

    private static enum ShroomType {
        Blue,
        Green,
        Purple,
        Other;

    }
}

