/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.BoP;

import biomesoplenty.api.content.BOPCBlocks;
import com.github.bartimaeusnek.cropspp.CCropUtility;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class Bamboo
extends BasicCrop {
    public int tier() {
        return 2;
    }

    public String name() {
        return "Bamboo";
    }

    @Override
    public String discoveredBy() {
        return "Minepolz320";
    }

    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity / 1.3 + (double)nutrients / 1.2 + (double)air / 0.8);
    }

    public int stat(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 0;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public String[] attributes() {
        return new String[]{"Green", "Pointed", "Edgy"};
    }

    public int maxSize() {
        return 3;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() > 1;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }

    public ItemStack getGain(ICropTile crop) {
        return crop.getSize() > 1 ? new ItemStack(BOPCBlocks.bamboo, crop.getSize() - 1) : null;
    }

    public int growthDuration(ICropTile crop) {
        if (CCropUtility.isRainingOn(crop)) {
            return 100;
        }
        return 150;
    }

    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (!entity.func_70093_af()) {
            CCropUtility.damageEntity(entity, 1.0f);
        }
        return false;
    }

    @Override
    public List<String> getCropInformation() {
        return Arrays.asList("Has increased humidity requirements (x1.3)", "Has increased nutrient requirements (x1.2)", "Has decreased humidity and air requirements (x0.8)");
    }
}

