/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.symbols;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.IZenErrorLogger;
import stanhebben.zenscript.dump.IDumpable;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.expression.partial.PartialPackage;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.util.StringUtil;
import stanhebben.zenscript.util.ZenPosition;

public class SymbolPackage
implements IZenSymbol {
    private final HashMap<String, IZenSymbol> members;
    private final String name;

    public SymbolPackage(String name) {
        this.name = name;
        this.members = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, IZenSymbol> getPackages() {
        return this.members;
    }

    public IZenSymbol get(String name) {
        return this.members.get(name);
    }

    public void put(String name, IZenSymbol symbol, IZenErrorLogger errors) {
        String[] parts = StringUtil.split(name, '.');
        String[] pkgParts = Arrays.copyOf(parts, parts.length - 1);
        SymbolPackage pkgCurrent = this;
        String pkgName = null;
        for (String part : pkgParts) {
            pkgName = pkgName == null ? part : pkgName + '.' + part;
            if (pkgCurrent.members.containsKey(part)) {
                IZenSymbol member = pkgCurrent.members.get(part);
                if (member instanceof SymbolPackage) {
                    pkgCurrent = (SymbolPackage)member;
                    continue;
                }
                errors.error(null, part + " is not a package");
                return;
            }
            SymbolPackage child = new SymbolPackage(pkgName);
            pkgCurrent.members.put(part, child);
            pkgCurrent = child;
        }
        if (pkgCurrent.members.containsKey(parts[parts.length - 1])) {
            errors.error(null, parts[parts.length - 1] + " is already defined in that package");
        } else {
            pkgCurrent.members.put(parts[parts.length - 1], symbol);
        }
    }

    @Override
    public IPartialExpression instance(ZenPosition position) {
        return new PartialPackage(position, this);
    }

    public String toString() {
        return "SymbolPackage: " + this.name;
    }

    @Override
    public List<? extends IDumpable> asDumpedObject() {
        ArrayList<? extends IDumpable> list = new ArrayList<IDumpable>();
        for (Map.Entry<String, IZenSymbol> entry : this.members.entrySet()) {
            list.addAll(entry.getValue().asDumpedObject());
        }
        return list;
    }
}

