/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.expand;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="minecraft.item.IItemStack")
@ModOnly(value={"IC2"})
public class ItemExpansion {
    @ZenGetter(value="ic2getCharge")
    public static double getIC2Charge(IItemStack stack) {
        return ElectricItem.manager.getCharge(MineTweakerMC.getItemStack(stack));
    }

    @ZenGetter(value="ic2tier")
    public static int getIC2Tier(IItemStack stack) {
        ItemStack iStack = MineTweakerMC.getItemStack(stack);
        if (iStack.func_77973_b() instanceof IElectricItem) {
            return ((IElectricItem)iStack.func_77973_b()).getTier(iStack);
        }
        return 0;
    }

    @ZenGetter(value="ic2transferLimit")
    public static double getIC2TransferLimit(IItemStack stack) {
        ItemStack iStack = MineTweakerMC.getItemStack(stack);
        if (iStack.func_77973_b() instanceof IElectricItem) {
            return ((IElectricItem)iStack.func_77973_b()).getTransferLimit(iStack);
        }
        return 0.0;
    }

    @ZenGetter(value="ic2charged")
    public static IItemStack getIC2Charged(IItemStack stack) {
        ItemStack iStack = MineTweakerMC.getItemStack(stack);
        if (iStack.func_77973_b() instanceof IElectricItem) {
            IElectricItem eItem = (IElectricItem)iStack.func_77973_b();
            Item item = eItem.getChargedItem(iStack);
            ItemStack stack2 = new ItemStack(item, 1, 0);
            ElectricItem.manager.charge(stack2, eItem.getMaxCharge(stack2), eItem.getTier(stack2), true, false);
            return MineTweakerMC.getIItemStack(stack2);
        }
        return null;
    }

    @ZenGetter(value="ic2discharged")
    public static IItemStack getIC2Discharged(IItemStack stack) {
        ItemStack iStack = MineTweakerMC.getItemStack(stack);
        if (iStack.func_77973_b() instanceof IElectricItem) {
            IElectricItem eItem = (IElectricItem)iStack.func_77973_b();
            Item item = eItem.getEmptyItem(iStack);
            return MineTweakerMC.getItemStack(item, 1, 0);
        }
        return null;
    }

    @ZenMethod(value="ic2charge")
    public static IItemStack ic2Charge(IItemStack stack, double amount, @Optional int tier) {
        if (tier == 0) {
            tier = ItemExpansion.getIC2Tier(stack);
        }
        ItemStack iStack = MineTweakerMC.getItemStack(stack).func_77946_l();
        ElectricItem.manager.charge(iStack, amount, tier, true, false);
        return MineTweakerMC.getIItemStack(iStack);
    }

    @ZenMethod(value="ic2discharge")
    public static IItemStack ic2Discharge(IItemStack stack, int amount, @Optional int tier) {
        if (tier == 0) {
            tier = ItemExpansion.getIC2Tier(stack);
        }
        ItemStack iStack = MineTweakerMC.getItemStack(stack).func_77946_l();
        ElectricItem.manager.discharge(iStack, (double)amount, tier, true, false, false);
        return MineTweakerMC.getIItemStack(iStack);
    }
}

