/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.SocketClosedException;

final class SocketClosedByInterruptException
extends SocketClosedException {
    private static final long serialVersionUID = 1L;

    private SocketClosedByInterruptException() {
        super("Closed by interrupt");
    }

    static SocketClosedByInterruptException newInstanceAndClose(Closeable closeable) {
        Exception suppressed = null;
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException | RuntimeException e) {
            suppressed = e;
        }
        SocketClosedByInterruptException exc = new SocketClosedByInterruptException();
        if (suppressed != null) {
            exc.addSuppressed(suppressed);
        }
        return exc;
    }

    public @NonNull ClosedByInterruptException asClosedByInterruptException() {
        ClosedByInterruptException exc = new ClosedByInterruptException();
        exc.initCause(this);
        return exc;
    }
}

