/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io;

import java.io.IOException;
import java.io.OutputStream;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.KryoException;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io.Output;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.minlog.Log;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.Util;

public class OutputChunked
extends Output {
    public OutputChunked() {
    }

    public OutputChunked(int bufferSize) {
        super(bufferSize);
    }

    public OutputChunked(OutputStream outputStream) {
        super(outputStream);
    }

    public OutputChunked(OutputStream outputStream, int bufferSize) {
        super(outputStream, bufferSize);
    }

    @Override
    public void flush() throws KryoException {
        if (this.position() > 0) {
            try {
                this.writeChunkSize();
                super.flush();
            }
            catch (IOException ex) {
                throw new KryoException(ex);
            }
        } else {
            super.flush();
        }
    }

    private void writeChunkSize() throws IOException {
        int size = this.position();
        if (Log.TRACE) {
            Log.trace("kryo", "Write chunk: " + size + Util.pos(size));
        }
        OutputStream outputStream = this.getOutputStream();
        if ((size & 0xFFFFFF80) == 0) {
            outputStream.write(size);
            return;
        }
        outputStream.write(size & 0x7F | 0x80);
        if (((size >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream.write(size);
            return;
        }
        outputStream.write(size & 0x7F | 0x80);
        if (((size >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream.write(size);
            return;
        }
        outputStream.write(size & 0x7F | 0x80);
        if (((size >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream.write(size);
            return;
        }
        outputStream.write(size & 0x7F | 0x80);
        outputStream.write(size >>>= 7);
    }

    public void endChunk() {
        this.flush();
        if (Log.TRACE) {
            Log.trace("kryo", "End chunk.");
        }
        try {
            this.getOutputStream().write(0);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }
}

