/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tape;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.item.ItemPortableTapeDrive;
import pl.asie.computronics.tape.PortableTapeDrive;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.lib.audio.StreamingAudioPlayer;

public final class PortableDriveManager {
    public static final PortableDriveManager INSTANCE = new PortableDriveManager();
    private BiMap<String, PortableTapeDrive> drivesServer = HashBiMap.create();
    private BiMap<String, PortableTapeDrive> drivesClient = HashBiMap.create();

    private PortableDriveManager() {
    }

    private BiMap<String, PortableTapeDrive> drives(boolean client) {
        return client ? this.drivesClient : this.drivesServer;
    }

    public PortableTapeDrive getOrCreate(ItemStack stack, boolean client) {
        String id;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("tid")) {
            id = tag.func_74779_i("tid");
        } else {
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            id = UUID.randomUUID().toString();
            tag.func_74778_a("tid", id);
        }
        PortableTapeDrive drive = (PortableTapeDrive)this.drives(client).get((Object)id);
        if (drive == null) {
            drive = new PortableTapeDrive();
            drive.load(tag);
            this.add(id, drive, client);
        }
        return drive;
    }

    public void add(String id, PortableTapeDrive drive, boolean client) {
        this.drives(client).put((Object)id, (Object)drive);
    }

    public String getID(PortableTapeDrive drive, boolean client) {
        return (String)this.drives(client).inverse().get((Object)drive);
    }

    public PortableTapeDrive getTapeDrive(String id, boolean client) {
        return (PortableTapeDrive)this.drives(client).get((Object)id);
    }

    public boolean exists(String id, boolean client) {
        return this.drives(client).containsKey((Object)id);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!(o instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)o;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemPortableTapeDrive)) continue;
                PortableTapeDrive drive = INSTANCE.getOrCreate(stack, player.field_70170_p.field_72995_K);
                drive.resetTime();
                drive.updateCarrier((Entity)player, stack);
                drive.update();
            }
        }
        Iterator iterator = this.drives(false).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((PortableTapeDrive)entry.getValue()).time > 5) {
                ((PortableTapeDrive)entry.getValue()).switchState(TapeDriveState.State.STOPPED);
                iterator.remove();
                ((PortableTapeDrive)entry.getValue()).carrier = null;
                continue;
            }
            ++((PortableTapeDrive)entry.getValue()).time;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                int codecId;
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemPortableTapeDrive)) continue;
                PortableTapeDrive drive = INSTANCE.getOrCreate(stack, player.field_70170_p.field_72995_K);
                drive.resetTime();
                drive.updateCarrier((Entity)player, stack);
                drive.update();
                if (drive.getEnumState() != TapeDriveState.State.PLAYING || !Computronics.instance.audio.exists(codecId = drive.getSourceIdClient())) continue;
                StreamingAudioPlayer sound = Computronics.instance.audio.getPlayer(codecId);
                sound.updatePosition("computronics:dfpwm-" + codecId, (float)player.field_70165_t, (float)player.field_70163_u + 0.5f, (float)player.field_70161_v);
            }
            Iterator iterator = this.drives(true).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (((PortableTapeDrive)entry.getValue()).time > 5) {
                    ((PortableTapeDrive)entry.getValue()).switchState(TapeDriveState.State.STOPPED);
                    iterator.remove();
                    ((PortableTapeDrive)entry.getValue()).carrier = null;
                    continue;
                }
                ++((PortableTapeDrive)entry.getValue()).time;
            }
        }
    }

    public void onServerStop() {
        this.drivesServer.clear();
        this.drivesClient.clear();
    }
}

