/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.network;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.network.TilePacket;
import com.carpentersblocks.util.EntityLivingUtil;
import com.carpentersblocks.util.ModLogger;
import com.carpentersblocks.util.handler.EventHandler;
import cpw.mods.fml.common.eventhandler.Event;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PacketActivateBlock
extends TilePacket {
    private int side;

    public PacketActivateBlock() {
    }

    public PacketActivateBlock(int x, int y, int z, int side) {
        super(x, y, z);
        this.side = side;
    }

    @Override
    public void processData(EntityPlayer entityPlayer, ByteBufInputStream bbis) throws IOException {
        boolean result;
        PlayerInteractEvent pie;
        super.processData(entityPlayer, bbis);
        EventHandler.IGNORE_INTERACT_EVENT = pie = new PlayerInteractEvent(entityPlayer, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, this.x, this.y, this.z, this.side, entityPlayer.field_70170_p);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)pie);
        EventHandler.IGNORE_INTERACT_EVENT = null;
        if (cancelled || pie.useBlock == Event.Result.DENY) {
            ModLogger.logger.warn(ModLogger.securityMarker, "Player {} denied block interaction at {}, {}, {}", new Object[]{entityPlayer.func_146103_bH(), this.x, this.y, this.z});
            return;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        this.side = bbis.readInt();
        Block block = entityPlayer.field_70170_p.func_147439_a(this.x, this.y, this.z);
        if (!(block instanceof BlockCoverable)) {
            ModLogger.logger.warn(ModLogger.securityMarker, "Player {} tried to use PacketActivateBlock on a non-carpenters block at {}, {}, {}", new Object[]{entityPlayer.func_146103_bH(), this.x, this.y, this.z});
        }
        if (!(result = block.func_149727_a(entityPlayer.field_70170_p, this.x, this.y, this.z, entityPlayer, this.side, 1.0f, 1.0f, 1.0f)) && itemStack != null && itemStack.func_77973_b() instanceof ItemBlock) {
            itemStack.func_77943_a(entityPlayer, entityPlayer.field_70170_p, this.x, this.y, this.z, this.side, 1.0f, 1.0f, 1.0f);
            EntityLivingUtil.decrementCurrentSlot(entityPlayer);
        }
    }

    @Override
    public void appendData(ByteBuf buffer) throws IOException {
        super.appendData(buffer);
        buffer.writeInt(this.side);
    }
}

