/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.api.sacrifice.IIncense;
import WayofTime.alchemicalWizardry.api.sacrifice.PlayerSacrificeHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEInventory;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.World;

public class TECrucible
extends TEInventory {
    private int radius = 5;
    public float rColour;
    public float gColour;
    public float bColour;
    public int ticksRemaining = 0;
    public int minValue = 0;
    public int maxValue = 0;
    public float incrementValue = 0.0f;
    public int state = 0;

    public TECrucible() {
        super(1);
        float f = 1.0f;
        float f1 = f * 0.6f + 0.4f;
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        this.rColour = f1;
        this.gColour = f2;
        this.bColour = f3;
    }

    public void func_145845_h() {
        ItemStack stack;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean stateChanged = false;
        if (this.ticksRemaining <= 0 && (stack = this.func_70301_a(0)) != null && stack.func_77973_b() instanceof IIncense) {
            IIncense incense = (IIncense)stack.func_77973_b();
            this.rColour = incense.getRedColour(stack);
            this.gColour = incense.getGreenColour(stack);
            this.bColour = incense.getBlueColour(stack);
            this.ticksRemaining = incense.getIncenseDuration(stack);
            this.minValue = incense.getMinLevel(stack);
            this.maxValue = incense.getMaxLevel(stack);
            this.incrementValue = incense.getTickRate(stack);
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                this.func_70299_a(0, null);
            }
            stateChanged = true;
        }
        if (this.ticksRemaining > 0) {
            List<EntityPlayer> playerList = SpellHelper.getPlayersInRange(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.radius, this.radius);
            if (playerList != null && !playerList.isEmpty()) {
                boolean allAreGood = true;
                for (EntityPlayer player : playerList) {
                    if (this.ticksRemaining <= 0 || !PlayerSacrificeHandler.incrementIncense(player, this.minValue, this.maxValue, this.incrementValue)) continue;
                    --this.ticksRemaining;
                    if (this.state != 2) {
                        this.state = 2;
                        stateChanged = true;
                    }
                    allAreGood = false;
                }
                if (allAreGood && this.state != 1) {
                    this.state = 1;
                    stateChanged = true;
                }
            } else if (this.state != 0) {
                this.state = 0;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.updateNeighbors();
            }
        } else if (this.state != 0) {
            this.state = 0;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.updateNeighbors();
        }
        if (stateChanged) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.updateNeighbors();
        }
    }

    private void updateNeighbors() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        block.func_149695_a(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, block);
        block = this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        block.func_149695_a(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, block);
        block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, block);
        block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, block);
        block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, block);
        block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, block);
    }

    public void spawnClientParticle(World world, int x, int y, int z, Random rand) {
        switch (this.state) {
            case 0: {
                world.func_72869_a("reddust", (double)x + 0.5 + rand.nextGaussian() / 8.0, (double)y + 0.7, (double)z + 0.5 + rand.nextGaussian() / 8.0, 0.15, 0.15, 0.15);
                break;
            }
            case 1: {
                world.func_72869_a("reddust", (double)x + 0.5 + rand.nextGaussian() / 8.0, (double)y + 0.7, (double)z + 0.5 + rand.nextGaussian() / 8.0, 1.0, 1.0, 1.0);
                break;
            }
            case 2: {
                world.func_72869_a("reddust", (double)x + 0.5 + rand.nextGaussian() / 8.0, (double)y + 0.7, (double)z + 0.5 + rand.nextGaussian() / 8.0, (double)this.rColour, (double)this.gColour, (double)this.bColour);
                world.func_72869_a("flame", (double)x + 0.5 + rand.nextGaussian() / 32.0, (double)y + 0.7, (double)z + 0.5 + rand.nextGaussian() / 32.0, 0.0, 0.02, 0.0);
                break;
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("ticksRemaining", this.ticksRemaining);
        tag.func_74768_a("minValue", this.minValue);
        tag.func_74768_a("maxValue", this.maxValue);
        tag.func_74776_a("increment", this.incrementValue);
        this.writeClientNBT(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ticksRemaining = tag.func_74762_e("ticksRemaining");
        this.minValue = tag.func_74762_e("minValue");
        this.maxValue = tag.func_74762_e("maxValue");
        this.incrementValue = tag.func_74760_g("increment");
        this.readClientNBT(tag);
    }

    public void writeClientNBT(NBTTagCompound tag) {
        tag.func_74776_a("rColour", this.rColour);
        tag.func_74776_a("gColour", this.gColour);
        tag.func_74776_a("bColour", this.bColour);
        tag.func_74768_a("state", this.state);
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(stackTag);
            invList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Inventory", (NBTBase)invList);
    }

    public void readClientNBT(NBTTagCompound tag) {
        this.rColour = tag.func_74760_g("rColour");
        this.gColour = tag.func_74760_g("gColour");
        this.bColour = tag.func_74760_g("bColour");
        this.state = tag.func_74762_e("state");
        NBTTagList invList = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = invList.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeClientNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 90210, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readClientNBT(packet.func_148857_g());
    }

    @Override
    public String func_145825_b() {
        return "TECrucible";
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null ? stack.func_77973_b() instanceof IIncense : false;
    }

    public int getRSPowerOutput() {
        return this.state == 1 || this.state == 0 ? 0 : 15;
    }
}

