/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import WayofTime.alchemicalWizardry.common.items.EnergyBattery;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.tileEntity.TESocket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class SigilLava
extends ItemBucket
implements ArmourUpgrade,
ISigil {
    private Block isFull = Blocks.field_150353_l;
    private int energyUsed;

    public SigilLava() {
        super(Blocks.field_150353_l);
        this.field_77777_bU = 1;
        this.setEnergyUsed(AlchemicalWizardry.sigilLavaCost);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:LavaSigil");
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack copiedStack = itemStack.func_77946_l();
        copiedStack.func_77964_b(copiedStack.func_77960_j() + this.getEnergyUsed());
        copiedStack.field_77994_a = 1;
        return copiedStack;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.lavasigil.desc1"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.lavasigil.desc2"));
        if (par1ItemStack.func_77978_p() != null) {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.owner.currentowner") + " " + par1ItemStack.func_77978_p().func_74779_i("ownerName"));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || !EnergyItems.checkAndSetItemOwner(stack, player) || player.func_70093_af()) {
            return false;
        }
        if (!world.func_72962_a(player, x, y, z)) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IFluidHandler) {
            FluidStack fluid = new FluidStack(FluidRegistry.LAVA, 1000);
            int amount = ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)side), fluid, false);
            if (amount > 0 && EnergyItems.syphonBatteries(stack, player, this.getEnergyUsed())) {
                ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)side), fluid, true);
            }
            return false;
        }
        if (tile instanceof TESocket) {
            return false;
        }
        if (side == 0) {
            --y;
        }
        if (side == 1) {
            ++y;
        }
        if (side == 2) {
            --z;
        }
        if (side == 3) {
            ++z;
        }
        if (side == 4) {
            --x;
        }
        if (side == 5) {
            ++x;
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        if (this.canPlaceContainedLiquid(world, x, y, z, x, y, z) && EnergyItems.syphonBatteries(stack, player, this.getEnergyUsed())) {
            return this.tryPlaceContainedLiquid(world, x, y, z, x, y, z);
        }
        return false;
    }

    public boolean tryPlaceContainedLiquid(World par1World, double par2, double par4, double par6, int par8, int par9, int par10) {
        if (!par1World.func_147437_c(par8, par9, par10) && par1World.func_147439_a(par8, par9, par10).func_149688_o().func_76220_a()) {
            return false;
        }
        if ((par1World.func_147439_a(par8, par9, par10) == Blocks.field_150353_l || par1World.func_147439_a(par8, par9, par10) == Blocks.field_150356_k) && par1World.func_72805_g(par8, par9, par10) == 0) {
            return false;
        }
        par1World.func_147465_d(par8, par9, par10, this.isFull, 0, 3);
        return true;
    }

    public boolean canPlaceContainedLiquid(World par1World, double par2, double par4, double par6, int par8, int par9, int par10) {
        if (!par1World.func_147437_c(par8, par9, par10) && par1World.func_147439_a(par8, par9, par10).func_149688_o().func_76220_a()) {
            return false;
        }
        return par1World.func_147439_a(par8, par9, par10) != Blocks.field_150353_l && par1World.func_147439_a(par8, par9, par10) != Blocks.field_150356_k || par1World.func_72805_g(par8, par9, par10) != 0;
    }

    protected void setEnergyUsed(int par1int) {
        this.energyUsed = par1int;
    }

    protected int getEnergyUsed() {
        return this.energyUsed;
    }

    protected boolean syphonBatteries(ItemStack ist, EntityPlayer player, int damageToBeDone) {
        if (!player.field_71075_bZ.field_75098_d) {
            boolean usedBattery = false;
            InventoryPlayer inventory = player.field_71071_by;
            for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                ItemStack stack = inventory.func_70301_a(slot);
                if (stack == null || !(stack.func_77973_b() instanceof EnergyBattery) || usedBattery || stack.func_77960_j() > stack.func_77958_k() - damageToBeDone) continue;
                stack.func_77964_b(stack.func_77960_j() + damageToBeDone);
                usedBattery = true;
            }
            return usedBattery;
        }
        return true;
    }

    @Override
    public void onArmourUpdate(World world, EntityPlayer player, ItemStack thisItemStack) {
        player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 2, 9, true));
        player.func_70066_B();
    }

    @Override
    public boolean isUpgrade() {
        return true;
    }

    @Override
    public int getEnergyForTenSeconds() {
        return 100;
    }
}

