/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.tileentity;

import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.event.RitualActivatedEvent;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.LocalRitualStorage;
import WayofTime.alchemicalWizardry.api.rituals.RitualBreakMethod;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCompactedMRS
extends TEMasterStone
implements IMasterRitualStone {
    private boolean isActive = false;
    private String owner = "";
    private String varString1 = "";
    private int cooldown = 0;
    private int var1 = 0;
    private int direction = 0;
    public boolean isRunning = false;
    public int runningTime = 0;
    public String ritualName = "";
    public LocalRitualStorage storage;
    private NBTTagCompound customRitualTag;
    protected ReagentContainer[] tanks = new ReagentContainer[]{new ReagentContainer(1000), new ReagentContainer(1000), new ReagentContainer(1000)};
    protected Map<Reagent, Integer> attunedTankMap = new HashMap<Reagent, Integer>();

    public TileCompactedMRS() {
        this.customRitualTag = new NBTTagCompound();
    }

    public void readNBTOnPlace(NBTTagCompound tag) {
        this.ritualName = tag.func_74779_i("ritualName");
    }

    public void writeNBTOnHarvest(NBTTagCompound tag) {
        tag.func_74778_a("ritualName", this.ritualName);
    }

    public void readClientNBT(NBTTagCompound tag) {
        this.ritualName = tag.func_74779_i("ritualName");
        this.isRunning = tag.func_74767_n("isRunning");
        this.runningTime = tag.func_74762_e("runningTime");
        NBTTagList tagList = tag.func_150295_c("reagentTanks", 10);
        int size = tagList.func_74745_c();
        this.tanks = new ReagentContainer[size];
        for (int i = 0; i < size; ++i) {
            NBTTagCompound savedTag = tagList.func_150305_b(i);
            this.tanks[i] = ReagentContainer.readFromNBT((NBTTagCompound)savedTag);
        }
    }

    public void writeClientNBT(NBTTagCompound tag) {
        tag.func_74778_a("ritualName", this.ritualName);
        tag.func_74757_a("isRunning", this.isRunning);
        tag.func_74768_a("runningTime", this.runningTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.tanks[i] != null) {
                this.tanks[i].writeToNBT(savedTag);
            }
            tagList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("reagentTanks", (NBTBase)tagList);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.isActive = tag.func_74767_n("isActive");
        this.owner = tag.func_74779_i("owner");
        this.cooldown = tag.func_74762_e("cooldown");
        this.var1 = tag.func_74762_e("var1");
        this.direction = tag.func_74762_e("direction");
        this.ritualName = tag.func_74779_i("ritualName");
        this.isRunning = tag.func_74767_n("isRunning");
        this.runningTime = tag.func_74762_e("runningTime");
        NBTTagList tagList = tag.func_150295_c("reagentTanks", 10);
        int size = tagList.func_74745_c();
        this.tanks = new ReagentContainer[size];
        for (int i = 0; i < size; ++i) {
            NBTTagCompound savedTag = tagList.func_150305_b(i);
            this.tanks[i] = ReagentContainer.readFromNBT((NBTTagCompound)savedTag);
        }
        NBTTagList attunedTagList = tag.func_150295_c("attunedTankMap", 10);
        for (int i = 0; i < attunedTagList.func_74745_c(); ++i) {
            NBTTagCompound savedTag = attunedTagList.func_150305_b(i);
            Reagent reagent = ReagentRegistry.getReagentForKey((String)savedTag.func_74779_i("reagent"));
            this.attunedTankMap.put(reagent, savedTag.func_74762_e("amount"));
        }
        this.customRitualTag = tag.func_74775_l("customRitualTag");
        LocalRitualStorage newStorage = Rituals.getLocalStorage((String)this.ritualName);
        NBTTagCompound localStorageTag = tag.func_74775_l("localStorage");
        if (newStorage != null) {
            newStorage.readFromNBT(localStorageTag);
            this.storage = newStorage;
            this.storage.xCoord = this.field_145851_c;
            this.storage.yCoord = this.field_145848_d;
            this.storage.zCoord = this.field_145849_e;
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("isActive", this.isActive);
        tag.func_74778_a("owner", this.owner);
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74768_a("var1", this.var1);
        tag.func_74768_a("direction", this.direction);
        tag.func_74778_a("ritualName", this.ritualName);
        tag.func_74757_a("isRunning", this.isRunning);
        tag.func_74768_a("runningTime", this.runningTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.tanks[i] != null) {
                this.tanks[i].writeToNBT(savedTag);
            }
            tagList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("reagentTanks", (NBTBase)tagList);
        NBTTagList attunedTagList = new NBTTagList();
        for (Map.Entry entry : this.attunedTankMap.entrySet()) {
            NBTTagCompound savedTag = new NBTTagCompound();
            savedTag.func_74778_a("reagent", ReagentRegistry.getKeyForReagent((Reagent)((Reagent)entry.getKey())));
            savedTag.func_74768_a("amount", ((Integer)entry.getValue()).intValue());
            attunedTagList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("attunedTankMap", (NBTBase)attunedTagList);
        tag.func_74782_a("customRitualTag", (NBTBase)this.customRitualTag);
        if (this.storage != null) {
            NBTTagCompound localStorageTag = new NBTTagCompound();
            this.storage.writeToNBT(localStorageTag);
            tag.func_74782_a("localStorage", (NBTBase)localStorageTag);
        }
    }

    public void activateRitual(World world, int crystalLevel, ItemStack activationCrystal, EntityPlayer player, String crystalOwner) {
        if (world.field_72995_K) {
            return;
        }
        RitualActivatedEvent event = new RitualActivatedEvent((IMasterRitualStone)this, crystalOwner, this.ritualName, player, activationCrystal, crystalLevel);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.masterstone.somethingstoppedyou")));
            return;
        }
        int eventCrystalTier = event.crystalTier;
        String eventRitualKey = event.ritualKey;
        String eventOwnerKey = event.ownerKey;
        boolean testLevel = Rituals.canCrystalActivate((String)eventRitualKey, (int)eventCrystalTier);
        if (!testLevel) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.masterstone.crystalvibrates")));
            return;
        }
        int currentEssence = SoulNetworkHandler.getCurrentEssence((String)eventOwnerKey);
        if (currentEssence < Rituals.getCostForActivation((String)this.ritualName)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.masterstone.youfeelapull")));
            return;
        }
        if (!world.field_72995_K) {
            if (!Rituals.startRitual((IMasterRitualStone)this, (String)this.ritualName, (EntityPlayer)player)) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.masterstone.ritualresistyou")));
                return;
            }
            int drain = SoulNetworkHandler.syphonFromNetwork((String)eventOwnerKey, (int)Rituals.getCostForActivation((String)this.ritualName));
            if (drain > 0) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.masterstone.energyflows")));
                for (int i = 0; i < 12; ++i) {
                    SpellHelper.sendIndexedParticleToAllAround((World)world, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (int)20, (int)this.field_145850_b.field_73011_w.field_76574_g, (int)1, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.masterstone.somethingstoppedyou")));
                return;
            }
        }
        if (!this.ritualName.equals("")) {
            Rituals.onRitualBroken((IMasterRitualStone)this, (String)this.ritualName, (RitualBreakMethod)RitualBreakMethod.ACTIVATE);
        }
        this.setOwner(eventOwnerKey);
        this.cooldown = Rituals.getInitialCooldown((String)this.ritualName);
        this.var1 = 0;
        this.storage = Rituals.getLocalStorage((String)this.ritualName);
        this.storage.setLocation(new Int3(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.isActive = true;
        this.isRunning = true;
        this.direction = Rituals.getDirectionOfRitual((World)world, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)this.ritualName);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void useOnRitualBroken() {
        Rituals.onRitualBroken((IMasterRitualStone)this, (String)this.ritualName, (RitualBreakMethod)RitualBreakMethod.BREAK_MRS);
    }

    public void useOnRitualBrokenExplosion() {
        Rituals.onRitualBroken((IMasterRitualStone)this, (String)this.ritualName, (RitualBreakMethod)RitualBreakMethod.EXPLOSION);
    }

    public void func_145845_h() {
        if (this.isRunning && this.runningTime < 100) {
            ++this.runningTime;
        } else if (!this.isRunning && this.runningTime > 0) {
            --this.runningTime;
        }
        if (!this.isActive) {
            return;
        }
        int worldTime = (int)(this.field_145850_b.func_72820_D() % 24000L);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (worldTime % 100 == 0) {
            SpellHelper.sendIndexedParticleToAllAround((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (int)20, (int)this.field_145850_b.field_73011_w.field_76574_g, (int)1, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            if (this.isRunning) {
                Rituals.onRitualBroken((IMasterRitualStone)this, (String)this.ritualName, (RitualBreakMethod)RitualBreakMethod.REDSTONE);
                this.isRunning = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return;
        }
        if (!this.isRunning) {
            this.isRunning = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.performRitual(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.ritualName);
    }

    public void performRitual(World world, int x, int y, int z, String currentRitualString) {
        Rituals.performEffect((IMasterRitualStone)this, (String)this.ritualName);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setCooldown(int newCooldown) {
        this.cooldown = newCooldown;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setVar1(int newVar1) {
        this.var1 = newVar1;
    }

    public int getVar1() {
        return this.var1;
    }

    public void setActive(boolean active) {
        Rituals.onRitualBroken((IMasterRitualStone)this, (String)this.ritualName, (RitualBreakMethod)RitualBreakMethod.DEACTIVATE);
        this.isActive = active;
        this.isRunning = active;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getDirection() {
        return this.direction;
    }

    public World getWorld() {
        return this.func_145831_w();
    }

    public int getXCoord() {
        return this.field_145851_c;
    }

    public int getYCoord() {
        return this.field_145848_d;
    }

    public int getZCoord() {
        return this.field_145849_e;
    }

    public String getCurrentRitual() {
        return this.ritualName;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeClientNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readClientNBT(packet.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtention = 1.0;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - renderExtention), (double)((double)this.field_145848_d - renderExtention), (double)((double)this.field_145849_e - renderExtention), (double)((double)(this.field_145851_c + 1) + renderExtention), (double)((double)(this.field_145848_d + 1) + renderExtention), (double)((double)(this.field_145849_e + 1) + renderExtention));
        return bb;
    }

    public int fill(ForgeDirection from, ReagentStack resource, boolean doFill) {
        boolean useTankLimit;
        if (doFill) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        int totalFill = 0;
        boolean bl = useTankLimit = !this.attunedTankMap.isEmpty();
        if (resource != null) {
            ReagentStack remainingStack;
            int i;
            int totalTanksFillable = useTankLimit ? this.getTanksTunedToReagent(resource.reagent) : this.tanks.length;
            int tanksFilled = 0;
            int maxFill = resource.amount;
            for (i = this.tanks.length - 1; i >= 0; --i) {
                boolean doesReagentMatch;
                remainingStack = resource.copy();
                remainingStack.amount = maxFill - totalFill;
                boolean bl2 = doesReagentMatch = this.tanks[i].getReagent() == null ? false : this.tanks[i].getReagent().isReagentEqual(remainingStack);
                if (!doesReagentMatch || (totalFill += this.tanks[i].fill(remainingStack, doFill)) < maxFill && ++tanksFilled < totalTanksFillable) continue;
                return totalFill;
            }
            if (tanksFilled >= totalTanksFillable) {
                return totalFill;
            }
            for (i = this.tanks.length - 1; i >= 0; --i) {
                boolean isTankEmpty;
                remainingStack = resource.copy();
                remainingStack.amount = maxFill - totalFill;
                boolean bl3 = isTankEmpty = this.tanks[i].getReagent() == null;
                if (!isTankEmpty || (totalFill += this.tanks[i].fill(remainingStack, doFill)) < maxFill && ++tanksFilled < totalTanksFillable) continue;
                return totalFill;
            }
        }
        return totalFill;
    }

    public ReagentStack drain(ForgeDirection from, ReagentStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (doDrain) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        int maxDrain = resource.amount;
        Reagent reagent = resource.reagent;
        int drained = 0;
        for (int i = 0; i < this.tanks.length && drained < maxDrain; ++i) {
            ReagentStack drainStack;
            if (!resource.isReagentEqual(this.tanks[i].getReagent()) || (drainStack = this.tanks[i].drain(maxDrain - drained, doDrain)) == null) continue;
            drained += drainStack.amount;
        }
        return new ReagentStack(reagent, drained);
    }

    public ReagentStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        for (int i = 0; i < this.tanks.length; ++i) {
            ReagentStack stack = this.tanks[i].drain(maxDrain, doDrain);
            if (stack == null) continue;
            if (doDrain) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return stack;
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Reagent reagent) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Reagent reagent) {
        return true;
    }

    public ReagentContainerInfo[] getContainerInfo(ForgeDirection from) {
        ReagentContainerInfo[] info = new ReagentContainerInfo[this.getNumberOfTanks()];
        for (int i = 0; i < this.getNumberOfTanks(); ++i) {
            info[i] = this.tanks[i].getInfo();
        }
        return info;
    }

    public int getNumberOfTanks() {
        return this.tanks.length;
    }

    public int getTanksTunedToReagent(Reagent reagent) {
        if (this.attunedTankMap.containsKey(reagent) && this.attunedTankMap.get(reagent) != null) {
            return this.attunedTankMap.get(reagent);
        }
        return 0;
    }

    public void setTanksTunedToReagent(Reagent reagent, int total) {
        if (total == 0 && this.attunedTankMap.containsKey(reagent)) {
            this.attunedTankMap.remove(reagent);
            return;
        }
        this.attunedTankMap.put(reagent, new Integer(total));
    }

    public Map<Reagent, Integer> getAttunedTankMap() {
        return this.attunedTankMap;
    }

    public boolean areTanksEmpty() {
        for (int i = 0; i < this.tanks.length; ++i) {
            if (this.tanks[i] == null || this.tanks[i].getReagent() == null) continue;
            return false;
        }
        return true;
    }

    public NBTTagCompound getCustomRitualTag() {
        return this.customRitualTag;
    }

    public void setCustomRitualTag(NBTTagCompound tag) {
        this.customRitualTag = tag;
    }

    public int getRunningTime() {
        return this.runningTime;
    }

    public LocalRitualStorage getLocalStorage() {
        return this.storage;
    }

    public void setLocalStorage(LocalRitualStorage storage) {
        this.storage = storage;
    }

    public void setRitualName(String ritualName) {
        this.ritualName = ritualName;
    }
}

