/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.core;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.common.configuration.BOPConfigurationMain;
import biomesoplenty.common.entities.EntityBird;
import biomesoplenty.common.entities.EntityGlob;
import biomesoplenty.common.entities.EntityJungleSpider;
import biomesoplenty.common.entities.EntityPhantom;
import biomesoplenty.common.entities.EntityPixie;
import biomesoplenty.common.entities.EntityRosester;
import biomesoplenty.common.entities.EntityWasp;
import biomesoplenty.common.entities.projectiles.EntityDart;
import biomesoplenty.common.entities.projectiles.EntityMudball;
import cpw.mods.fml.common.registry.EntityRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;

public class BOPEntities {
    public static int eggIdCounter = 300;
    public static int EntID = 0;

    public static void init() {
        BOPEntities.registerEntities();
    }

    private static void registerEntities() {
        boolean mobSpawns = BOPConfigurationMain.mobSpawns;
        EntityRegistry.registerModEntity(EntityDart.class, (String)"dart", (int)EntID++, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityMudball.class, (String)"mudball", (int)EntID++, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityJungleSpider.class, (String)"JungleSpider", (int)EntID++, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        BOPEntities.registerEntityEgg(EntityJungleSpider.class, 5147192, 11013646);
        if (mobSpawns && BOPConfigurationMain.spawnJungleSpider) {
            EntityRegistry.addSpawn(EntityJungleSpider.class, (int)8, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BOPCBiomes.bambooForest, BiomeGenBase.field_76782_w, BOPCBiomes.tropicalRainforest, BOPCBiomes.oasis, BOPCBiomes.tropics, BOPCBiomes.mangrove, BOPCBiomes.sacredSprings, BOPCBiomes.rainforest});
        }
        EntityRegistry.registerModEntity(EntityRosester.class, (String)"Rosester", (int)EntID++, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        BOPEntities.registerEntityEgg(EntityRosester.class, 14831439, 16756224);
        if (mobSpawns && BOPConfigurationMain.spawnRosester) {
            EntityRegistry.addSpawn(EntityRosester.class, (int)10, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{BOPCBiomes.garden});
        }
        EntityRegistry.registerModEntity(EntityGlob.class, (String)"Glob", (int)EntID++, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        BOPEntities.registerEntityEgg(EntityGlob.class, 6836276, 8414787);
        if (mobSpawns && BOPConfigurationMain.spawnGlob) {
            EntityRegistry.addSpawn(EntityGlob.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{BOPCBiomes.deadSwamp, BOPCBiomes.fen, BOPCBiomes.moor, BOPCBiomes.quagmire, BOPCBiomes.sludgepit, BiomeGenBase.field_76780_h});
        }
        EntityRegistry.registerModEntity(EntityPhantom.class, (String)"Phantom", (int)EntID++, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        BOPEntities.registerEntityEgg(EntityPhantom.class, 4472140, 2499368);
        if (BOPCBiomes.boneyard != null && BOPCBiomes.corruptedSands != null && mobSpawns && BOPConfigurationMain.spawnPhantom) {
            EntityRegistry.addSpawn(EntityPhantom.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BOPCBiomes.boneyard, BOPCBiomes.corruptedSands});
        }
        EntityRegistry.registerModEntity(EntityWasp.class, (String)"Wasp", (int)EntID++, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        BOPEntities.registerEntityEgg(EntityWasp.class, 16434729, 0x262627);
        EntityRegistry.registerModEntity(EntityBird.class, (String)"Bird", (int)EntID++, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        BOPEntities.registerEntityEgg(EntityBird.class, 5277691, 16772788);
        EntityRegistry.registerModEntity(EntityPixie.class, (String)"Pixie", (int)EntID++, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        BOPEntities.registerEntityEgg(EntityPixie.class, 0xFF77DD, 16645116);
        if (mobSpawns && BOPConfigurationMain.spawnPixie) {
            EntityRegistry.addSpawn(EntityPixie.class, (int)8, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.ambient, (BiomeGenBase[])new BiomeGenBase[]{BOPCBiomes.mysticGrove});
        }
    }

    public static void registerEntityEgg(Class<? extends Entity> entity, int primaryColor, int secondaryColor) {
        int id = BOPEntities.getUniqueEntityEggId();
        EntityList.field_75623_d.put(id, entity);
        EntityList.field_75627_a.put(id, new EntityList.EntityEggInfo(id, primaryColor, secondaryColor));
    }

    public static int getUniqueEntityEggId() {
        while (EntityList.func_75617_a((int)(++eggIdCounter)) != null) {
        }
        return eggIdCounter;
    }
}

