/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import jds.bibliocraft.ClientProxy;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.tileentities.TileEntityLamp;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLamp
extends BlockContainer {
    public int styleType = 0;

    public BlockLamp() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149715_a(1.0f);
        this.func_149647_a(BlockLoader.biblioLightsTab);
    }

    public void func_149719_a(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity pretile = blockAccess.func_147438_o(i, j, k);
        if (pretile != null && pretile instanceof TileEntityLamp) {
            TileEntityLamp tile = (TileEntityLamp)pretile;
            int style = tile.getStyle();
            switch (style) {
                case 0: {
                    this.func_149676_a(0.18f, 0.0f, 0.18f, 0.82f, 1.0f, 0.82f);
                    break;
                }
                case 1: {
                    this.func_149676_a(0.1f, 0.05f, 0.1f, 0.9f, 0.55f, 0.9f);
                    break;
                }
                case 2: {
                    this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
                    break;
                }
                default: {
                    this.func_149676_a(0.18f, 0.0f, 0.18f, 0.82f, 1.0f, 0.82f);
                    break;
                }
            }
        } else {
            this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
        }
    }

    public int getLightValue(IBlockAccess world, int i, int j, int k) {
        return 15;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("gold_block");
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs tab, List subItems) {
        for (int x = 0; x <= 15; ++x) {
            subItems.add(new ItemStack((Block)this, 1, x));
        }
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase player, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ++angle;
        angle %= 4;
        int angle2 = MathHelper.func_76128_c((double)((double)(player.field_70125_A * 3.0f / 180.0f) + 0.5)) & 3;
        ++angle2;
        angle2 %= 4;
        TileEntityLamp lampTile = (TileEntityLamp)world.func_147438_o(i, j, k);
        if (lampTile != null) {
            lampTile.setAngle(angle);
            lampTile.setMetal(0);
            if (angle2 == 0) {
                lampTile.setStyle(this.styleType);
            } else if (angle2 == 1) {
                lampTile.setStyle(this.styleType);
            } else {
                lampTile.setStyle(this.styleType);
            }
        }
    }

    public int func_149660_a(World world, int i, int j, int k, int side, float hitX, float hitY, float hitZ, int meta) {
        this.styleType = side == 0 ? 2 : (side == 1 ? 0 : 1);
        return meta;
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.libLampRenderID;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int face, float hitx, float hity, float hitz) {
        if (!world.field_72995_K) {
            TileEntity tile;
            int dyeColor;
            ItemStack playerStack = player.func_71045_bC();
            if (playerStack != null && playerStack.func_77973_b() instanceof ItemDye && (dyeColor = this.getLampColorFromMeta(playerStack.func_77960_j())) != world.func_72805_g(i, j, k) && (tile = world.func_147438_o(i, j, k)) instanceof TileEntityLamp) {
                TileEntityLamp lamp = (TileEntityLamp)tile;
                int angle = lamp.getAngle();
                int metal = lamp.getMetal();
                int style = lamp.getStyle();
                world.func_72921_c(i, j, k, dyeColor, 3);
                lamp.setData(angle, style, metal);
                if (playerStack.field_77994_a > 1) {
                    --playerStack.field_77994_a;
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            TileEntityLamp tile2 = (TileEntityLamp)world.func_147438_o(i, j, k);
            if (tile2 != null) {
                tile2.setIsLightOff(!tile2.getIsLightOff());
            }
        }
        return false;
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int par6) {
        super.func_149749_a(world, i, j, k, par5, par6);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            return new TileEntityLamp();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private int getLampColorFromMeta(int meta) {
        switch (meta) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 14;
            }
            case 10: {
                return 7;
            }
            case 11: {
                return 6;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 5;
            }
            case 15: {
                return 0;
            }
        }
        return 0;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityLamp) {
            TileEntityLamp te = (TileEntityLamp)tile;
            int angle = te.getAngle();
            switch (axis) {
                case NORTH: {
                    te.setAngle(1);
                    break;
                }
                case EAST: {
                    te.setAngle(2);
                    break;
                }
                case SOUTH: {
                    te.setAngle(3);
                    break;
                }
                case WEST: {
                    te.setAngle(0);
                    break;
                }
                case DOWN: {
                    if (angle <= 0) {
                        te.setAngle(3);
                        break;
                    }
                    te.setAngle(angle - 1);
                    break;
                }
                case UP: {
                    if (angle >= 3) {
                        te.setAngle(0);
                        break;
                    }
                    te.setAngle(angle + 1);
                    break;
                }
                case UNKNOWN: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }
}

