/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.client.gui.tasks.PanelTaskRetrieval;
import bq_standard.tasks.ITaskInventory;
import bq_standard.tasks.ITaskItemInput;
import bq_standard.tasks.base.TaskProgressableBase;
import bq_standard.tasks.factory.FactoryTaskRetrieval;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import drethic.questbook.config.QBConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class TaskRetrieval
extends TaskProgressableBase<int[]>
implements ITaskInventory,
IItemTask,
ITaskItemInput {
    public final List<BigItemStack> requiredItems = new ArrayList<BigItemStack>();
    public boolean partialMatch = true;
    public boolean ignoreNBT = true;
    public boolean consume = false;
    public boolean groupDetect = false;
    public boolean autoConsume = false;

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("partialMatch", this.partialMatch);
        nbt.func_74757_a("ignoreNBT", this.ignoreNBT);
        nbt.func_74757_a("consume", this.consume);
        nbt.func_74757_a("groupDetect", this.groupDetect);
        nbt.func_74757_a("autoConsume", this.autoConsume);
        NBTTagList itemArray = new NBTTagList();
        for (BigItemStack stack : this.requiredItems) {
            itemArray.func_74742_a((NBTBase)JsonHelper.ItemStackToJson(stack, new NBTTagCompound()));
        }
        nbt.func_74782_a("requiredItems", (NBTBase)itemArray);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.partialMatch = nbt.func_74767_n("partialMatch");
        this.ignoreNBT = nbt.func_74767_n("ignoreNBT");
        this.consume = nbt.func_74767_n("consume");
        this.groupDetect = nbt.func_74767_n("groupDetect");
        this.autoConsume = nbt.func_74767_n("autoConsume");
        this.requiredItems.clear();
        NBTTagList iList = nbt.func_150295_c("requiredItems", 10);
        for (int i = 0; i < iList.func_74745_c(); ++i) {
            this.requiredItems.add(JsonHelper.JsonToItemStack(iList.func_150305_b(i)));
        }
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.retrieval";
    }

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskRetrieval.INSTANCE.getRegistryName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, Map.Entry<UUID, IQuest> quest) {
        return new PanelTaskRetrieval(rect, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, Map.Entry<UUID, IQuest> quest) {
        return null;
    }

    @Override
    public int[] getUsersProgress(UUID uuid) {
        int[] progress = (int[])this.userProgress.get(uuid);
        return progress == null || progress.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : progress;
    }

    @Override
    public int[] readUserProgressFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("data", 9)) {
            int[] data = new int[this.requiredItems.size()];
            List<NBTBase> dNbt = NBTConverter.getTagList(nbt.func_150295_c("data", 3));
            for (int i = 0; i < data.length && i < dNbt.size(); ++i) {
                data[i] = ((NBTBase.NBTPrimitive)dNbt.get(i)).func_150287_d();
            }
            return data;
        }
        int[] data = nbt.func_74759_k("data");
        int[] progress = new int[this.requiredItems.size()];
        System.arraycopy(data, 0, progress, 0, Math.min(data.length, progress.length));
        return progress;
    }

    @Override
    public void writeUserProgressToNBT(NBTTagCompound nbt, int[] progress) {
        nbt.func_74783_a("data", progress);
    }

    @Override
    public void detect(ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest) {
        List<InventoryPlayer> invoList;
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        Detector detector = new Detector(this, this.consume && !QBConfig.fullySyncQuests ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        if (this.consume) {
            invoList = Collections.singletonList(pInfo.PLAYER.field_71071_by);
        } else {
            invoList = new ArrayList<InventoryPlayer>(pInfo.ACTIVE_PLAYERS.size());
            pInfo.ACTIVE_PLAYERS.forEach(p -> invoList.add(p.field_71071_by));
        }
        for (InventoryPlayer invo : invoList) {
            IntStream.range(0, invo.func_70302_i_()).forEachOrdered(i -> {
                ItemStack stack = invo.func_70301_a(i);
                detector.run(stack, remaining -> invo.func_70298_a(i, remaining), pInfo.UUID);
            });
        }
        if (detector.updated) {
            this.setBulkProgress(detector.progress);
        }
        this.checkAndComplete(pInfo, quest, detector.updated, detector.progress);
    }

    private void checkAndComplete(ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest, boolean resync, List<Tuple2<UUID, int[]>> progress) {
        boolean updated = resync;
        block0: for (Tuple2<UUID, int[]> value : progress) {
            for (int j = 0; j < this.requiredItems.size(); ++j) {
                if (value.func_76340_b()[j] < this.requiredItems.get((int)j).stackSize) continue block0;
            }
            updated = true;
            if (this.consume && !QBConfig.fullySyncQuests) {
                this.setComplete(value.func_76341_a());
                continue;
            }
            progress.forEach(pair -> this.setComplete((UUID)pair.func_76341_a()));
            break;
        }
        if (updated) {
            if (this.consume && !QBConfig.fullySyncQuests) {
                pInfo.markDirty(quest.getKey());
            } else {
                pInfo.markDirtyParty(quest.getKey());
            }
        }
    }

    @Override
    public boolean canAcceptItem(UUID owner, Map.Entry<UUID, IQuest> quest, ItemStack stack) {
        if (owner == null || stack == null || stack.field_77994_a <= 0 || !this.consume || this.isComplete(owner) || this.requiredItems.size() <= 0) {
            return false;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredItems.size(); ++j) {
            BigItemStack rStack = this.requiredItems.get(j);
            if (progress[j] >= rStack.stackSize || !ItemComparison.StackMatch(rStack.getBaseStack(), stack, !this.ignoreNBT, this.partialMatch) && !ItemComparison.OreDictionaryMatch(rStack.getOreIngredient(), rStack.GetTagCompound(), stack, !this.ignoreNBT, this.partialMatch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack submitItem(UUID owner, Map.Entry<UUID, IQuest> quest, ItemStack input) {
        if (owner == null || input == null || !this.consume || this.isComplete(owner)) {
            return input;
        }
        ParticipantInfo pInfo = new ParticipantInfo((EntityPlayer)QuestingAPI.getPlayer(owner));
        Detector detector = new Detector(this, QBConfig.fullySyncQuests ? pInfo.ALL_UUIDS : Collections.singletonList(pInfo.UUID));
        ItemStack stack = input.func_77946_l();
        detector.run(stack, remaining -> {
            int removed = Math.min(stack.field_77994_a, remaining);
            return stack.func_77979_a(removed);
        }, owner);
        if (detector.updated) {
            this.setBulkProgress(detector.progress);
        }
        return 0 < stack.field_77994_a ? stack : null;
    }

    @Override
    public void retrieveItems(ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest, ItemStack[] stacks) {
        if (this.consume || this.isComplete(pInfo.UUID)) {
            return;
        }
        Detector detector = new Detector(this, pInfo.ALL_UUIDS);
        for (ItemStack stack : stacks) {
            detector.run(stack, remaining -> null, pInfo.UUID);
        }
        if (detector.updated) {
            this.setBulkProgress(detector.progress);
        }
        this.checkAndComplete(pInfo, quest, detector.updated, detector.progress);
    }

    @Override
    public void onInventoryChange(@Nonnull Map.Entry<UUID, IQuest> quest, @Nonnull ParticipantInfo pInfo) {
        if (!this.consume || this.autoConsume) {
            this.detect(pInfo, quest);
        }
    }

    @Override
    public List<String> getTextsForSearch() {
        ArrayList<String> texts = new ArrayList<String>();
        for (BigItemStack bigStack : this.requiredItems) {
            ItemStack stack = bigStack.getBaseStack();
            texts.add(stack.func_82833_r());
            if (!bigStack.hasOreDict()) continue;
            texts.add(bigStack.getOreDict());
        }
        return texts;
    }

    @Override
    public List<BigItemStack> getItemInputs() {
        return this.requiredItems;
    }

    static class Detector {
        public boolean updated = false;
        public final TaskRetrieval task;
        public final List<Tuple2<UUID, int[]>> progress;
        private final int[] remCounts;

        public Detector(TaskRetrieval task, @Nonnull List<UUID> uuids) {
            this.task = task;
            this.progress = task.getBulkProgress(uuids);
            this.remCounts = new int[this.progress.size()];
            if (!task.consume) {
                if (task.groupDetect) {
                    this.progress.forEach(value -> Arrays.fill((int[])value.func_76340_b(), 0));
                } else {
                    for (int i = 0; i < task.requiredItems.size(); ++i) {
                        int r = task.requiredItems.get((int)i).stackSize;
                        for (Tuple2<UUID, int[]> value2 : this.progress) {
                            int n = value2.func_76340_b()[i];
                            if (n == 0 || n >= r) continue;
                            value2.func_76340_b()[i] = 0;
                            this.updated = true;
                        }
                    }
                }
            }
        }

        public void run(ItemStack stack, IntFunction<ItemStack> consumer, UUID runner) {
            if (stack == null || stack.field_77994_a <= 0) {
                return;
            }
            Arrays.fill(this.remCounts, stack.field_77994_a);
            for (int i = 0; i < this.task.requiredItems.size(); ++i) {
                BigItemStack rStack = this.task.requiredItems.get(i);
                if (!ItemComparison.StackMatch(rStack.getBaseStack(), stack, !this.task.ignoreNBT, this.task.partialMatch) && !ItemComparison.OreDictionaryMatch(rStack.getOreIngredient(), rStack.GetTagCompound(), stack, !this.task.ignoreNBT, this.task.partialMatch)) continue;
                for (int n = 0; n < this.progress.size(); ++n) {
                    Tuple2<UUID, int[]> value = this.progress.get(n);
                    if (value.func_76340_b()[i] >= rStack.stackSize) continue;
                    int remaining = rStack.stackSize - value.func_76340_b()[i];
                    if (this.task.consume) {
                        if (QBConfig.fullySyncQuests && runner.equals(value.func_76341_a())) {
                            ItemStack removed = consumer.apply(remaining);
                            int temp = i;
                            this.progress.forEach(p -> {
                                int[] nArray = (int[])p.func_76340_b();
                                int n = temp;
                                nArray[n] = nArray[n] + removed.field_77994_a;
                            });
                        } else if (!QBConfig.fullySyncQuests) {
                            ItemStack removed = consumer.apply(remaining);
                            int[] nArray = value.func_76340_b();
                            int n2 = i;
                            nArray[n2] = nArray[n2] + removed.field_77994_a;
                        }
                    } else {
                        int temp = Math.min(remaining, this.remCounts[n]);
                        int n3 = n;
                        this.remCounts[n3] = this.remCounts[n3] - temp;
                        int[] nArray = value.func_76340_b();
                        int n4 = i;
                        nArray[n4] = nArray[n4] + temp;
                    }
                    this.updated = true;
                }
            }
        }
    }
}

