/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api.utils.UuidConverter;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.questing.QuestDatabase;
import bq_standard.client.gui.rewards.PanelRewardQuestCompletion;
import bq_standard.rewards.factory.FactoryRewardQuestCompletion;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class RewardQuestCompletion
implements IReward {
    public UUID questNum = null;

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryRewardQuestCompletion.INSTANCE.getRegistryName();
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.reward.questcompletion";
    }

    @Override
    public boolean canClaim(EntityPlayer player, Map.Entry<UUID, IQuest> quest) {
        return true;
    }

    @Override
    public void claimReward(EntityPlayer player, Map.Entry<UUID, IQuest> quest) {
        if (this.questNum == null) {
            return;
        }
        IQuest targetQuest = (IQuest)QuestingAPI.getAPI(ApiReference.QUEST_DB).get(this.questNum);
        if (targetQuest == null) {
            return;
        }
        QuestCache qc = (QuestCache)player.getExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString());
        if (qc == null) {
            return;
        }
        UUID questId = QuestDatabase.INSTANCE.lookupKey(targetQuest);
        if (questId == null) {
            return;
        }
        UUID uuid = QuestingAPI.getQuestingUUID(player);
        if (!targetQuest.isComplete(uuid)) {
            targetQuest.setComplete(uuid, System.currentTimeMillis());
            qc.markQuestDirty(questId);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        Optional<UUID> uuid = NBTConverter.UuidValueType.QUEST.tryReadIdString(nbt);
        this.questNum = uuid.isPresent() ? uuid.get() : (nbt.func_150297_b("quest", 99) ? UuidConverter.convertLegacyId(nbt.func_74762_e("quest")) : null);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTConverter.UuidValueType.QUEST.writeIdString(this.questNum, nbt);
        return nbt;
    }

    @Override
    public IGuiPanel getRewardGui(IGuiRect rect, Map.Entry<UUID, IQuest> quest) {
        return new PanelRewardQuestCompletion(rect, this);
    }

    @Override
    public GuiScreen getRewardEditor(GuiScreen screen, Map.Entry<UUID, IQuest> quest) {
        return null;
    }
}

