/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.UuidConverter;
import betterquesting.api2.utils.Tuple2;
import betterquesting.client.importers.ImportedQuestLines;
import betterquesting.client.importers.ImportedQuests;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.network.handlers.NetChapterSync;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class NetImport {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:import");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetImport::onServer);
    }

    public static void sendImport(@Nonnull IQuestDatabase questDB, @Nonnull IQuestLineDatabase chapterDB) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("quests", questDB.writeToNBT((NBTBase)new NBTTagList(), null));
        payload.func_74782_a("chapters", chapterDB.writeToNBT((NBTBase)new NBTTagList(), null));
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = message.func_76340_b();
        if (sender.field_71133_b == null) {
            return;
        }
        boolean isOP = sender.field_71133_b.func_71203_ab().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to import quests without OP permissions!");
            sender.func_146105_b((IChatComponent)new ChatComponentText(ChatFormatting.RED + "You need to be OP to edit quests!"));
            return;
        }
        ImportedQuests impQuestDB = new ImportedQuests();
        ImportedQuestLines impQuestLineDB = new ImportedQuestLines();
        impQuestDB.readFromNBT(message.func_76341_a().func_150295_c("quests", 10), false);
        impQuestLineDB.readFromNBT((NBTBase)message.func_76341_a().func_150295_c("chapters", 10), false);
        BetterQuesting.logger.log(Level.INFO, "Importing " + impQuestDB.size() + " quest(s) and " + impQuestLineDB.size() + " quest line(s) from " + sender.func_146103_bH().getName());
        BiMap<UUID, UUID> remapped = NetImport.getRemappedIDs(impQuestDB.keySet());
        for (Map.Entry entry : impQuestDB.entrySet()) {
            Set newRequirements = ((IQuest)entry.getValue()).getRequirements().stream().map(req -> (UUID)remapped.getOrDefault(req, req)).collect(Collectors.toCollection(HashSet::new));
            ((IQuest)entry.getValue()).setRequirements(newRequirements);
            QuestDatabase.INSTANCE.put((UUID)remapped.get((Object)entry.getKey()), (IQuest)entry.getValue());
        }
        for (IQuestLine questLine : impQuestLineDB.values()) {
            HashSet pendingQLE = new HashSet(questLine.entrySet());
            questLine.clear();
            for (Map.Entry qle : pendingQLE) {
                if (!remapped.containsKey(qle.getKey())) {
                    BetterQuesting.logger.error("Failed to import quest into quest line. Unable to remap ID " + UuidConverter.encodeUuid((UUID)qle.getKey()));
                    continue;
                }
                questLine.put((UUID)remapped.get(qle.getKey()), (IQuestLineEntry)qle.getValue());
            }
            QuestLineDatabase.INSTANCE.put(QuestLineDatabase.INSTANCE.generateKey(), questLine);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NetQuestSync.quickSync(null, true, true);
        NetChapterSync.sendSync(null, null);
    }

    private static BiMap<UUID, UUID> getRemappedIDs(Set<UUID> ids) {
        Set<UUID> nextIDs = NetImport.getNextIDs(ids.size());
        HashBiMap remapped = HashBiMap.create((int)ids.size());
        Iterator<UUID> nextIDIterator = nextIDs.iterator();
        for (UUID id : ids) {
            remapped.put((Object)id, (Object)nextIDIterator.next());
        }
        return remapped;
    }

    private static Set<UUID> getNextIDs(int num) {
        HashSet<UUID> nextIds = new HashSet<UUID>();
        while (nextIds.size() < num) {
            nextIds.add(QuestDatabase.INSTANCE.generateKey());
        }
        return nextIds;
    }
}

