/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.utils;

import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.utils.UuidConverter;
import betterquesting.core.BetterQuesting;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.StatCollector;

public class QuestTranslation {
    private static final String QUEST_NAME_KEY = "betterquesting.quest.%s.name";
    private static final String QUEST_DESCRIPTION_KEY = "betterquesting.quest.%s.desc";
    private static final String QUEST_LINE_NAME_KEY = "betterquesting.questline.%s.name";
    private static final String QUEST_LINE_DESCRIPTION_KEY = "betterquesting.questline.%s.desc";

    public static String translate(String text, Object ... args) {
        String out = I18n.func_135052_a((String)text, (Object[])args);
        if (out.startsWith("Format error: ")) {
            return text;
        }
        return out;
    }

    public static String translateTrimmed(String text, Object ... args) {
        return QuestTranslation.translate(text, args).replaceAll("\r", "");
    }

    public static String buildQuestNameKey(UUID questId) {
        return String.format(QUEST_NAME_KEY, UuidConverter.encodeUuidStripPadding(questId));
    }

    public static String translateQuestName(UUID questId, IQuest quest) {
        return QuestTranslation.translateProperty(QuestTranslation.buildQuestNameKey(questId), quest, NativeProps.NAME);
    }

    public static String translateQuestName(Map.Entry<UUID, IQuest> entry) {
        return QuestTranslation.translateQuestName(entry.getKey(), entry.getValue());
    }

    public static String buildQuestDescriptionKey(UUID questId) {
        return String.format(QUEST_DESCRIPTION_KEY, UuidConverter.encodeUuidStripPadding(questId));
    }

    public static String translateQuestDescription(UUID questId, IQuest quest) {
        return QuestTranslation.translateProperty(QuestTranslation.buildQuestDescriptionKey(questId), quest, NativeProps.DESC);
    }

    public static String translateQuestDescription(Map.Entry<UUID, IQuest> entry) {
        return QuestTranslation.translateQuestDescription(entry.getKey(), entry.getValue());
    }

    public static String buildQuestLineNameKey(UUID questLineId) {
        return String.format(QUEST_LINE_NAME_KEY, UuidConverter.encodeUuidStripPadding(questLineId));
    }

    public static String translateQuestLineName(UUID questLineId, IQuestLine questLine) {
        return QuestTranslation.translateProperty(QuestTranslation.buildQuestLineNameKey(questLineId), questLine, NativeProps.NAME);
    }

    public static String translateQuestLineName(Map.Entry<UUID, IQuestLine> entry) {
        return QuestTranslation.translateQuestLineName(entry.getKey(), entry.getValue());
    }

    public static String buildQuestLineDescriptionKey(UUID questLineId) {
        return String.format(QUEST_LINE_DESCRIPTION_KEY, UuidConverter.encodeUuidStripPadding(questLineId));
    }

    public static String translateQuestLineDescription(UUID questLineId, IQuestLine questLine) {
        return QuestTranslation.translateProperty(QuestTranslation.buildQuestLineDescriptionKey(questLineId), questLine, NativeProps.DESC);
    }

    public static String translateQuestLineDescription(Map.Entry<UUID, IQuestLine> entry) {
        return QuestTranslation.translateQuestLineDescription(entry.getKey(), entry.getValue());
    }

    public static int getColor(String key) {
        String hex = QuestTranslation.translate(key, new Object[0]);
        int color = 0;
        if (hex.length() <= 6) {
            try {
                color = Integer.parseUnsignedInt(hex, 16);
            }
            catch (NumberFormatException e) {
                BetterQuesting.logger.warn("Couldn't format color correctly for: " + key, (Throwable)e);
            }
        }
        return color;
    }

    private static String translateProperty(String key, IPropertyContainer container, IPropertyType<String> property) {
        if (StatCollector.func_94522_b((String)key)) {
            return StatCollector.func_74837_a((String)key, (Object[])new Object[0]);
        }
        return container.getProperty(property);
    }
}

