/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.ReflectionHelper;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.logging.log4j.Level;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.entities.EntityXPOrbSuppressFollow;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;

public class TjUtil {
    private static Random rand = new Random();
    public static final char decimalSeparator;
    private static char[] c;
    private static int MAX_XP_ORB_VALUE;
    private static Method getDeathSound;
    private static Method getSoundVolume;

    public static void sendChatToPlayer(EntityPlayer player, String message) {
        message = StatCollector.func_74838_a((String)message);
        TjUtil.sendRawChatToPlayer(player, message, EnumChatFormatting.DARK_AQUA);
    }

    public static void sendFormattedChatToPlayer(EntityPlayer player, String message, Object ... data) {
        message = StatCollector.func_74837_a((String)message, (Object[])data);
        TjUtil.sendRawChatToPlayer(player, message, EnumChatFormatting.DARK_AQUA);
    }

    public static void sendRawChatToPlayer(EntityPlayer player, String message, EnumChatFormatting chatFormatting) {
        if (chatFormatting != null) {
            message = chatFormatting + message;
        }
        player.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    public static ArrayList<String> getMultiLineLocalizedString(String message) {
        message = StatCollector.func_74838_a((String)message);
        String[] s = message.split("\\\\n");
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(s));
        return lines;
    }

    public static Pattern getSafePatternUsingAsteriskForWildcard(String str) {
        Pattern p;
        String s = str.replaceAll("\\*+", ".*");
        s = Pattern.quote(s);
        s = s.replace(".*", "\\E.*\\Q");
        s = s.replace("\\Q\\E", "");
        try {
            p = Pattern.compile(s);
        }
        catch (Exception ex) {
            FMLLog.severe((String)("[Automagy] Failed to create regex pattern. Name filter will not function properly. String was: " + str), (Object[])new Object[0]);
            return null;
        }
        return p;
    }

    public static int getSideFromEntityFacing(EntityLivingBase entity) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        switch (l) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    public static int getOppositeSide(int side) {
        return side >= 0 && side < ForgeDirection.OPPOSITES.length ? ForgeDirection.OPPOSITES[side] : 6;
    }

    public static int getSWNESide(int side) {
        switch (side) {
            case 2: {
                return 2;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 3;
            }
        }
        return -1;
    }

    public static boolean isEntityLookingDown(EntityLivingBase entity) {
        return entity.field_70125_A > 0.0f;
    }

    public static int getNextSideOnBlockFromDir(int side, int dir) {
        switch (side) {
            case 0: 
            case 1: {
                switch (dir) {
                    case 0: 
                    case 1: {
                        return 6;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return dir;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                switch (dir) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: 
                    case 3: {
                        return 6;
                    }
                    case 4: {
                        return 4;
                    }
                    case 5: {
                        return 5;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                switch (dir) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                    case 4: 
                    case 5: {
                        return 6;
                    }
                }
            }
        }
        return 6;
    }

    public static float getDistanceBetweenPoints(int x1, int y1, int z1, int x2, int y2, int z2) {
        float f = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
        return MathHelper.func_76129_c((float)f);
    }

    public static double getDistanceBetweenPoints_squared(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
    }

    public static double getDistanceBetweenPoints_double(double x1, double y1, double z1, double x2, double y2, double z2) {
        double f = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
        return MathHelper.func_76133_a((double)f);
    }

    public static void dropItemsIntoWorld(IInventory inventory, World world, int x, int y, int z, Block block) {
        if (inventory != null) {
            for (int i1 = 0; i1 < inventory.func_70302_i_(); ++i1) {
                ItemStack stack = inventory.func_70301_a(i1);
                if (stack == null) continue;
                TjUtil.dropItemIntoWorld(stack, world, x, y, z);
            }
            if (block != null) {
                world.func_147453_f(x, y, z, block);
            }
        }
    }

    public static void dropItemsIntoWorld(IInventory inventory, World world, double x, double y, double z) {
        if (inventory != null) {
            for (int i1 = 0; i1 < inventory.func_70302_i_(); ++i1) {
                ItemStack stack = inventory.func_70301_a(i1);
                if (stack == null) continue;
                TjUtil.dropItemIntoWorld(stack, world, x, y, z);
            }
        }
    }

    public static void dropItemsIntoWorld(ArrayList<ItemStack> list, World world, int x, int y, int z) {
        if (list != null) {
            int size = list.size();
            for (int i1 = 0; i1 < size; ++i1) {
                ItemStack stack = list.get(i1);
                if (stack == null) continue;
                TjUtil.dropItemIntoWorld(stack, world, x, y, z);
            }
        }
    }

    public static void dropItemsIntoWorld(ItemStack[] list, World world, int x, int y, int z) {
        if (list != null) {
            for (ItemStack stack : list) {
                if (stack == null) continue;
                TjUtil.dropItemIntoWorld(stack, world, x, y, z);
            }
        }
    }

    public static EntityItem dropItemIntoWorld(ItemStack stack, World world, double x, double y, double z) {
        float f = rand.nextFloat() * 0.8f + 0.1f;
        float f1 = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entityitem = null;
        float f2 = rand.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int j1 = rand.nextInt(21) + 10;
            if (j1 > stack.field_77994_a) {
                j1 = stack.field_77994_a;
            }
            stack.field_77994_a -= j1;
            entityitem = new EntityItem(world, x + (double)f, y + (double)f1, z + (double)f2, new ItemStack(stack.func_77973_b(), j1, stack.func_77960_j()));
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)rand.nextGaussian() * f3;
            entityitem.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)rand.nextGaussian() * f3;
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    public static EntityItem dropItemIntoWorldSimple(ItemStack stack, World world, double x, double y, double z) {
        EntityItem entityitem = new EntityItem(world, x, y, z, stack);
        float f3 = 0.05f;
        entityitem.field_70159_w = (float)rand.nextGaussian() * f3;
        entityitem.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
        entityitem.field_70179_y = (float)rand.nextGaussian() * f3;
        world.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static boolean canItemsStack(ItemStack stack1, ItemStack stack2) {
        return (stack1 == null || stack2 == null || TjUtil.areItemsEqualIgnoringSize(stack1, stack2)) && stack1.func_77985_e();
    }

    public static boolean areItemsEqualIgnoringSize(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (!stack2.func_77981_g() || stack2.func_77960_j() == stack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1);
    }

    public static ItemStack addToInventory(ItemStack stack, IInventory inv, int firstSlot, int lastSlot) {
        ItemStack slottedStack;
        int slot;
        stack = stack.func_77946_l();
        boolean reverse = firstSlot > lastSlot;
        int offSlot = reverse ? lastSlot - 1 : lastSlot + 1;
        int stacksTo = Math.min(stack.func_77976_d(), inv.func_70297_j_());
        if (stacksTo > 1 && stack.func_77985_e()) {
            slot = firstSlot;
            while (slot != offSlot) {
                slottedStack = inv.func_70301_a(slot);
                if (slottedStack != null && TjUtil.canItemsStack(stack, slottedStack)) {
                    ItemStack newStack;
                    int newSize = stack.field_77994_a + slottedStack.field_77994_a;
                    if (newSize <= stacksTo) {
                        newStack = slottedStack.func_77946_l();
                        newStack.field_77994_a = newSize;
                        inv.func_70299_a(slot, newStack);
                        return null;
                    }
                    if (slottedStack.field_77994_a < stacksTo) {
                        stack.field_77994_a = newSize - stacksTo;
                        newStack = slottedStack.func_77946_l();
                        newStack.field_77994_a = stacksTo;
                        inv.func_70299_a(slot, newStack);
                    }
                }
                if (reverse) {
                    --slot;
                    continue;
                }
                ++slot;
            }
        }
        slot = firstSlot;
        while (slot != offSlot) {
            slottedStack = inv.func_70301_a(slot);
            if (slottedStack == null) {
                if (stack.field_77994_a <= stacksTo) {
                    inv.func_70299_a(slot, stack.func_77946_l());
                    return null;
                }
                ItemStack newStack = stack.func_77946_l();
                newStack.field_77994_a = stacksTo;
                stack.field_77994_a -= stacksTo;
                inv.func_70299_a(slot, newStack);
            }
            if (reverse) {
                --slot;
                continue;
            }
            ++slot;
        }
        return stack;
    }

    public static ItemStack addToInventory(ItemStack stack, IInventory inv) {
        return TjUtil.addToInventory(stack, inv, 0, inv.func_70302_i_() - 1);
    }

    public static boolean isPlayerOnline(String name) {
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP curr : players) {
            if (curr.func_70005_c_() != name) continue;
            return true;
        }
        return false;
    }

    public static boolean areFloatsAlmostEqual_lowprec(float f1, float f2) {
        float epsilon = 1.0E-5f;
        return Math.abs(f1 - f2) < epsilon;
    }

    public static boolean areDoublesAlmostEqual_lowprec(double d1, double d2) {
        double epsilon = 1.0E-5;
        return Math.abs(d1 - d2) < epsilon;
    }

    public static int randInt(Random rand, int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static int round_to_int(double d) {
        return (int)Math.floor(d + 0.5);
    }

    public static BlockCoord getBlockCoordPlayerIsLookingAt(EntityPlayer player, World world) {
        float f8;
        float f6;
        double d3;
        float f5;
        if (player.field_70170_p != world && player.field_70170_p.field_73011_w.field_76574_g != world.field_73011_w.field_76574_g) {
            return null;
        }
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - (double)player.field_70129_M;
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180))));
        Vec3 vec31 = vec3.func_72441_c((double)f7 * (d3 = 5.0), (double)(f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)))) * d3, (double)(f8 = f3 * f5) * d3);
        MovingObjectPosition movingobjectposition = world.func_72901_a(vec3, vec31, true);
        if (movingobjectposition == null) {
            return null;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int ix = movingobjectposition.field_72311_b;
            int iy = movingobjectposition.field_72312_c;
            int iz = movingobjectposition.field_72309_d;
            return new BlockCoord(ix, iy, iz);
        }
        return null;
    }

    public static boolean isAcceptableSurfaceForBlock(World world, int x, int y, int z, boolean allowGlowstone, boolean allowGlass, boolean allowPedestal) {
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return true;
        }
        if (allowGlowstone || allowGlass || allowPedestal) {
            Block block = world.func_147439_a(x, y, z);
            if (allowGlowstone && block == Blocks.field_150426_aN) {
                return true;
            }
            if (allowGlass && block == Blocks.field_150359_w) {
                return true;
            }
            if (allowPedestal && ThaumcraftExtension.blockIsPedestal(block, world.func_72805_g(x, y, z), false)) {
                return true;
            }
        }
        return false;
    }

    public static boolean playerHasItem(EntityPlayer player, HashableItemWithoutSize item) {
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            if (inv.field_70462_a[i] == null || !item.isSameItem(inv.field_70462_a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean playerHasPartialStackedItem(EntityPlayer player, ItemStack stack) {
        if (!stack.func_77985_e()) {
            return false;
        }
        int max = stack.func_77976_d();
        if (max <= 1) {
            return false;
        }
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            ItemStack invStack = inv.field_70462_a[i];
            if (invStack == null || !invStack.func_77969_a(stack) || invStack.field_77994_a >= max) continue;
            return true;
        }
        return false;
    }

    public static void consumePlayerItem(EntityPlayer player, int slot, ItemStack replace, boolean replaceOnlyIfNoContainer) {
        boolean replaced = false;
        boolean needUpdate = false;
        boolean containerTookSlot = false;
        InventoryPlayer inv = player.field_71071_by;
        ItemStack stack = inv.func_70301_a(slot);
        if (stack != null) {
            ItemStack container = null;
            if (stack.func_77973_b().hasContainerItem(stack)) {
                container = stack.func_77973_b().getContainerItem(stack);
                if (replaceOnlyIfNoContainer && container != null) {
                    replace = null;
                }
            }
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                if (container != null && !TjUtil.playerHasPartialStackedItem(player, container)) {
                    inv.func_70299_a(slot, container);
                    containerTookSlot = true;
                    needUpdate = true;
                }
                if (!containerTookSlot && replace != null && !TjUtil.playerHasPartialStackedItem(player, replace)) {
                    inv.func_70299_a(slot, replace);
                    replaced = true;
                    needUpdate = true;
                }
            }
            if (container != null && !containerTookSlot) {
                if (!inv.func_70441_a(container)) {
                    if (player instanceof EntityPlayerMP) {
                        player.func_71019_a(container, false);
                    }
                } else {
                    needUpdate = true;
                }
            }
            if (replace != null && !replaced) {
                if (!inv.func_70441_a(replace)) {
                    if (player instanceof EntityPlayerMP) {
                        player.func_71019_a(replace, false);
                    }
                } else {
                    needUpdate = true;
                }
            }
            if (needUpdate && player instanceof EntityPlayerMP && !(player instanceof FakePlayer)) {
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            }
        }
    }

    public static void consumePlayerItem(EntityPlayer player, int slot, ItemStack replace) {
        TjUtil.consumePlayerItem(player, slot, replace, false);
    }

    public static void consumePlayerItem(EntityPlayer player, int slot) {
        TjUtil.consumePlayerItem(player, slot, null, false);
    }

    public static ArrayList<EntityPlayer> getPlayersInRangeSquared(World world, double x, double y, double z, double rangeSquared) {
        ArrayList<EntityPlayer> list = new ArrayList<EntityPlayer>();
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            double dist = player.func_70092_e(x, y, z);
            if (!(rangeSquared < 0.0) && !(dist < rangeSquared)) continue;
            list.add(player);
        }
        return list;
    }

    public static ArrayList<EntityPlayer> getPlayersIn2DRangeSquared(World world, double x, double z, double rangeSquared) {
        ArrayList<EntityPlayer> list = new ArrayList<EntityPlayer>();
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            double dist = TjUtil.get2DRangeSquared(x, z, player.field_70165_t, player.field_70161_v);
            if (!(rangeSquared < 0.0) && !(dist < rangeSquared)) continue;
            list.add(player);
        }
        return list;
    }

    public static double get2DRangeSquared(double x, double z, double x2, double z2) {
        double xx = x - x2;
        double zz = z - z2;
        return xx * xx + zz * zz;
    }

    public static boolean willAdditionOverflowInt(int left, int right) {
        if (right < 0 && right != Integer.MIN_VALUE) {
            return TjUtil.willSubtractionOverflowInt(left, -right);
        }
        return (~(left ^ right) & (left ^ left + right)) < 0;
    }

    public static boolean willSubtractionOverflowInt(int left, int right) {
        if (right < 0) {
            return TjUtil.willAdditionOverflowInt(left, -right);
        }
        return ((left ^ right) & (left ^ left - right)) < 0;
    }

    public static int overflowSafeAddInt(int a, int b) {
        if (TjUtil.willAdditionOverflowInt(a, b)) {
            return Integer.MAX_VALUE;
        }
        return a + b;
    }

    public static int overflowSafeSubtractInt(int a, int b) {
        if (TjUtil.willSubtractionOverflowInt(a, b)) {
            return Integer.MIN_VALUE;
        }
        return a - b;
    }

    private static String numberFormatLetter(double n, int iteration) {
        boolean isRound;
        double d = (double)((long)n / 100L) / 10.0;
        boolean bl = isRound = d * 10.0 % 10.0 == 0.0;
        return d < 1000.0 ? (d > 99.9 || isRound || !isRound && d > 9.99 ? Integer.valueOf((int)d * 10 / 10) : d + "") + "" + c[iteration] : TjUtil.numberFormatLetter(d, iteration + 1);
    }

    public static String numberFormatLetter(int n) {
        if (n < 1000) {
            return Integer.toString(n);
        }
        return TjUtil.numberFormatLetter(n, 0);
    }

    public static void itemStackToBytes(ByteBuf buf, ItemStack stack) {
        if (stack == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            buf.writeInt(stack.field_77994_a);
            buf.writeShort(stack.func_77960_j());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.func_77978_p());
        }
    }

    public static ItemStack itemStackFromBytes(ByteBuf buf) {
        short itemID = buf.readShort();
        if (itemID < 0) {
            return null;
        }
        int size = buf.readInt();
        short damage = buf.readShort();
        ItemStack stack = new ItemStack(Item.func_150899_d((int)itemID), size, (int)damage);
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (tag != null) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public static NBTTagCompound writeLargeItemStackToNBT(ItemStack stack, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
        nbt.func_74768_a("Count", stack.field_77994_a);
        nbt.func_74777_a("Damage", (short)stack.func_77960_j());
        if (stack.field_77990_d != null) {
            nbt.func_74782_a("tag", (NBTBase)stack.field_77990_d);
        }
        return nbt;
    }

    public static ItemStack readLargeItemStackFromNBT(NBTTagCompound nbt) {
        Item item = Item.func_150899_d((int)nbt.func_74765_d("id"));
        if (item == null) {
            return null;
        }
        int damage = Math.max(nbt.func_74765_d("Damage"), 0);
        ItemStack stack = new ItemStack(item, nbt.func_74762_e("Count"), damage);
        if (nbt.func_150297_b("tag", 10)) {
            stack.field_77990_d = nbt.func_74775_l("tag");
        }
        return stack;
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)TjUtil.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = TjUtil.getExperienceForLevel(level);
        int nextXP = TjUtil.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (TjUtil.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static void spawnExperienceIntoWorld(int xp, World world, double x, double y, double z, boolean addMotion, int orbValueCap, int suppressFollowTime) {
        while (xp > 0) {
            int orbXP = EntityXPOrb.func_70527_a((int)xp);
            if (orbXP > orbValueCap) {
                orbXP = orbValueCap;
            }
            xp -= orbXP;
            EntityXPOrb orb = suppressFollowTime > 0 ? new EntityXPOrbSuppressFollow(world, x, y, z, orbXP, suppressFollowTime) : new EntityXPOrb(world, x, y, z, orbXP);
            if (addMotion) {
                orb.field_70159_w *= 0.2;
                orb.field_70181_x *= 0.5;
                orb.field_70179_y *= 0.2;
            }
            world.func_72838_d((Entity)orb);
        }
    }

    public static void spawnSuppressedExperienceIntoWorld(int xp, int suppressFollowTime, World world, double x, double y, double z) {
        TjUtil.spawnExperienceIntoWorld(xp, world, x, y, z, true, MAX_XP_ORB_VALUE, suppressFollowTime);
    }

    public static void spawnExperienceIntoWorld(int xp, World world, double x, double y, double z, boolean addMotion) {
        TjUtil.spawnExperienceIntoWorld(xp, world, x, y, z, addMotion, MAX_XP_ORB_VALUE, 0);
    }

    public static boolean isPrecipitationAt(World world, int x, int z) {
        if (!world.func_72896_J()) {
            return false;
        }
        BiomeGenBase bg = world.func_72807_a(x, z);
        return bg.func_76746_c() || bg.func_76738_d();
    }

    public static boolean isChunkLoaded(World world, int blockX, int blockZ) {
        return world.func_72938_d((int)blockX, (int)blockZ).field_76636_d;
    }

    public static boolean isBiomeAt(World world, int x, int z, BiomeGenBase biome) {
        BiomeGenBase b = world.func_72807_a(x, z);
        return b == biome;
    }

    public static boolean isBiomeAt(World world, int x, int z, String biome) {
        BiomeGenBase b = world.func_72807_a(x, z);
        return b.field_76791_y.equals(biome);
    }

    public static ArrayList<ItemStack> getDropsFromBlock(World world, int x, int y, int z, boolean includeSilkDrops) {
        ItemStack stack;
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return null;
        }
        int md = world.func_72805_g(x, y, z);
        ArrayList drops = block.getDrops(world, x, y, z, md, 0);
        if (includeSilkDrops && (stack = TjUtil.getStackFromBlock(block, world, x, y, z)) != null) {
            boolean found = false;
            for (ItemStack drop : drops) {
                if (!TjUtil.areItemsEqualIgnoringSize(stack, drop)) continue;
                found = true;
                break;
            }
            if (!found) {
                drops.add(stack);
            }
        }
        return drops;
    }

    public static ItemStack getStackFromBlock(Block block, World world, int x, int y, int z) {
        Item item = Item.func_150898_a((Block)block);
        return item == null ? null : new ItemStack(item, 1, block.func_149643_k(world, x, y, z));
    }

    public static ItemStack getStackFromBlock(World world, int x, int y, int z) {
        return TjUtil.getStackFromBlock(world.func_147439_a(x, y, z), world, x, y, z);
    }

    public static String getBlockNameAt(World world, int x, int y, int z) {
        Block block;
        String name = null;
        if (TjUtil.isChunkLoaded(world, x, z) && (block = world.func_147439_a(x, y, z)) != null) {
            Item blockItem = block.func_149694_d(world, x, y, z);
            if (blockItem == null) {
                name = block.func_149739_a();
            } else {
                ItemStack blockStack = new ItemStack(blockItem, 1, block.func_149643_k(world, x, y, z));
                name = blockItem.func_77667_c(blockStack);
            }
            if (name != null) {
                String name2;
                if (name.isEmpty()) {
                    return null;
                }
                String temp = name + ".name";
                if (temp.equals(name2 = StatCollector.func_74838_a((String)temp))) {
                    temp = name + "." + world.func_72805_g(x, y, z) + ".name";
                    if (temp.equals(name2 = StatCollector.func_74838_a((String)temp))) {
                        if (name.substring(0, 5).equals("tile.")) {
                            name = name.substring(5);
                        }
                        name = name.substring(0, 1).toUpperCase() + name.substring(1);
                    } else {
                        name = name2;
                    }
                } else {
                    name = name2;
                }
            }
        }
        return name;
    }

    public static Fluid canDrainTank(IFluidHandler tank, ForgeDirection dir, Fluid fluid) {
        if (fluid != null) {
            return tank.canDrain(dir, fluid) ? fluid : null;
        }
        FluidTankInfo[] infos = tank.getTankInfo(dir);
        if (infos == null || infos.length < 1) {
            return null;
        }
        for (FluidTankInfo info : infos) {
            if (info.fluid == null || info.capacity <= 0 || !tank.canDrain(dir, fluid = info.fluid.getFluid())) continue;
            return fluid;
        }
        return null;
    }

    public static Fluid canDrainTank(IFluidHandler tank, ForgeDirection dir, FluidStack fluidStack) {
        return TjUtil.canDrainTank(tank, dir, fluidStack == null ? null : fluidStack.getFluid());
    }

    public static String getBlockUnlocalizedName(Block block, World world, int x, int y, int z) {
        Item blockItem = Item.func_150898_a((Block)block);
        if (blockItem == null) {
            return block.func_149739_a();
        }
        ItemStack blockStack = new ItemStack(blockItem, 1, block.func_149643_k(world, x, y, z));
        return blockItem.func_77667_c(blockStack);
    }

    public static void playDeathSound(EntityLiving entity, World world, double x, double y, double z, float pitch) {
        if (getDeathSound == null) {
            try {
                getDeathSound = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)entity, (String[])new String[]{"getDeathSound", "func_70673_aS"}, (Class[])new Class[0]);
                getSoundVolume = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)entity, (String[])new String[]{"getSoundVolume", "func_70599_aP"}, (Class[])new Class[0]);
            }
            catch (Exception ex) {
                FMLLog.warning((String)"[Automagy] Failed to find mob death sound.", (Object[])new Object[0]);
                ex.printStackTrace();
                return;
            }
        }
        try {
            String s = (String)getDeathSound.invoke((Object)entity, new Object[0]);
            Float v = (Float)getSoundVolume.invoke((Object)entity, new Object[0]);
            if (s != null && !s.isEmpty() && v != null) {
                world.func_72908_a(x, y, z, s, v.floatValue(), pitch);
            }
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Automagy] Failed to play mob death sound.", (Object[])new Object[0]);
            ex.printStackTrace();
        }
    }

    public static float dualInterpolate(float a, float b, float d) {
        if ((double)d < 0.5) {
            return tuhljin.automagy.codechicken.lib.math.MathHelper.interpolate(a, b, d * 2.0f);
        }
        return tuhljin.automagy.codechicken.lib.math.MathHelper.interpolate(b, a, (d - 0.5f) * 2.0f);
    }

    public static boolean doesBlockMovement(IBlockAccess blockaccess, int x, int y, int z) {
        Block block = blockaccess.func_147439_a(x, y, z);
        return block != null && block.func_149688_o().func_76230_c();
    }

    public static int colorApproachLinear(int a, int b, double max) {
        Color colorA = new Color(a);
        Color colorB = new Color(b);
        int red = (int)Math.round(tuhljin.automagy.codechicken.lib.math.MathHelper.approachLinear((double)colorA.getRed(), (double)colorB.getRed(), max));
        int green = (int)Math.round(tuhljin.automagy.codechicken.lib.math.MathHelper.approachLinear((double)colorA.getGreen(), (double)colorB.getGreen(), max));
        int blue = (int)Math.round(tuhljin.automagy.codechicken.lib.math.MathHelper.approachLinear((double)colorA.getBlue(), (double)colorB.getBlue(), max));
        Color result = new Color((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
        return result.getRGB();
    }

    public static void printError(String s) {
        FMLLog.log((Level)Level.ERROR, (String)("[Automagy] " + s), (Object[])new Object[0]);
    }

    public static void debug(String s) {
    }

    public static void debugxyz(int x, int y, int z, String s) {
    }

    static {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        decimalSeparator = format.getDecimalFormatSymbols().getDecimalSeparator();
        c = new char[]{'k', 'm', 'b', 't'};
        MAX_XP_ORB_VALUE = 100;
        getDeathSound = null;
        getSoundVolume = null;
    }
}

