/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.shape;

import gcewing.architecture.client.render.ITexture;
import gcewing.architecture.client.render.RenderWindow;
import gcewing.architecture.client.render.target.IRenderTarget;
import gcewing.architecture.common.shape.FrameKind;
import gcewing.architecture.common.shape.ShapeKind;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.Trans3;
import gcewing.architecture.compat.Vector3;
import gcewing.architecture.util.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public abstract class Window
extends ShapeKind {
    public EnumFacing[] frameSides;
    public boolean[] frameAlways;
    public FrameKind[] frameKinds;
    public EnumFacing[] frameOrientations;
    public Trans3[] frameTrans;
    static final ThreadLocal<RenderWindow> renderWindow = ThreadLocal.withInitial(RenderWindow::new);

    @Override
    public boolean orientOnPlacement(EntityPlayer player, TileShape te, TileShape nte, EnumFacing otherFace, Vector3 hit) {
        int turn = -1;
        if (!(player.func_70093_af() || nte != null && nte.shape.kind instanceof Window)) {
            switch (otherFace.ordinal()) {
                case 4: 
                case 5: {
                    int n = 0;
                    break;
                }
                case 2: 
                case 3: {
                    int n = 1;
                    break;
                }
                default: {
                    int n = turn = turn;
                }
            }
        }
        if (turn >= 0) {
            te.setSide(0);
            te.setTurn(turn);
            return true;
        }
        return false;
    }

    public FrameKind frameKindForLocalSide(EnumFacing side) {
        return this.frameKinds[side.ordinal()];
    }

    public EnumFacing frameOrientationForLocalSide(EnumFacing side) {
        return this.frameOrientations[side.ordinal()];
    }

    @Override
    public boolean canPlaceUpsideDown() {
        return false;
    }

    @Override
    public double sideZoneSize() {
        return 0.125;
    }

    @Override
    public boolean highlightZones() {
        return true;
    }

    @Override
    public void renderShape(TileShape te, ITexture[] textures, IRenderTarget target, Trans3 t, boolean renderBase, boolean renderSecondary) {
        RenderWindow renderWindow = Window.renderWindow.get();
        renderWindow.prepare(te, textures, t, target, renderBase, renderSecondary, this);
        renderWindow.render();
    }

    @Override
    public ItemStack newSecondaryMaterialStack(IBlockState state) {
        return BlockCompatUtils.blockStackWithState(state, 1);
    }

    @Override
    public boolean isValidSecondaryMaterial(IBlockState state) {
        Block block = state.getBlock();
        return block == Blocks.field_150410_aZ || block == Blocks.field_150397_co;
    }

    @Override
    public void addCollisionBoxesToList(TileShape te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t, List list) {
        double r = 0.125;
        double s = 0.09375;
        double[] e = new double[4];
        this.addCentreBoxesToList(0.125, 0.09375, t, list);
        for (int i = 0; i <= 3; ++i) {
            boolean frame;
            boolean bl = frame = this.frameAlways[i] || !this.isConnectedGlobal(te, t.t(this.frameSides[i]));
            if (entity == null || frame) {
                Trans3 ts = t.t(this.frameTrans[i]);
                this.addFrameBoxesToList(i, 0.125, 0.09375, ts, list);
            }
            e[i] = frame ? 0.375 : 0.5;
        }
        if (te.secondaryBlockState != null) {
            this.addGlassBoxesToList(0.125, 0.09375, 0.03125, e, t, list);
        }
    }

    protected void addCentreBoxesToList(double r, double s, Trans3 t, List list) {
    }

    protected void addFrameBoxesToList(int i, double r, double s, Trans3 ts, List list) {
        ts.addBox(-0.5, -0.5, -s, 0.5, -0.5 + r, s, list);
    }

    protected void addGlassBoxesToList(double r, double s, double w, double[] e, Trans3 t, List list) {
        t.addBox(-e[3], -e[0], -w, e[1], e[2], w, list);
    }

    protected boolean isConnectedGlobal(TileShape te, EnumFacing globalDir) {
        return this.getConnectedWindowGlobal(te, globalDir) != null;
    }

    public TileShape getConnectedWindowGlobal(TileShape te, EnumFacing globalDir) {
        EnumFacing thisLocalDir = te.localFace(globalDir);
        FrameKind thisFrameKind = this.frameKindForLocalSide(thisLocalDir);
        if (thisFrameKind != FrameKind.None) {
            EnumFacing otherLocalDir;
            Window otherKind;
            FrameKind otherFrameKind;
            ShapeKind shapeKind;
            EnumFacing thisOrient = this.frameOrientationForLocalSide(thisLocalDir);
            TileShape nte = te.getConnectedNeighbourGlobal(globalDir);
            if (nte != null && (shapeKind = nte.shape.kind) instanceof Window && (otherFrameKind = (otherKind = (Window)shapeKind).frameKindForLocalSide(otherLocalDir = nte.localFace(Utils.oppositeFacing(globalDir)))) != FrameKind.None) {
                EnumFacing otherOrient = otherKind.frameOrientationForLocalSide(otherLocalDir);
                if (this.framesMatch(thisFrameKind, otherFrameKind, te.globalFace(thisOrient), nte.globalFace(otherOrient))) {
                    return nte;
                }
            }
        }
        return null;
    }

    protected boolean framesMatch(FrameKind kind1, FrameKind kind2, EnumFacing orient1, EnumFacing orient2) {
        if (kind1 == kind2) {
            boolean bl;
            switch (kind1) {
                case Plain: {
                    bl = Utils.facingAxesEqual(orient1, orient2);
                    break;
                }
                default: {
                    bl = orient1 == orient2;
                }
            }
            return bl;
        }
        return false;
    }
}

