/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.texture;

import gcewing.architecture.client.render.ITexture;
import gcewing.architecture.client.texture.ITiledTexture;
import gcewing.architecture.client.texture.Image;
import gcewing.architecture.client.texture.TextureProxy;
import gcewing.architecture.client.texture.TextureSprite;
import gcewing.architecture.client.texture.TextureTileSet;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public abstract class ArchitectureTexture
implements ITexture {
    public ResourceLocation location;
    public int tintIndex;
    public double red = 1.0;
    public double green = 1.0;
    public double blue = 1.0;
    public boolean isEmissive;
    public boolean isProjected;

    @Override
    public int tintIndex() {
        return this.tintIndex;
    }

    @Override
    public double red() {
        return this.red;
    }

    @Override
    public double green() {
        return this.green;
    }

    @Override
    public double blue() {
        return this.blue;
    }

    @Override
    public boolean isEmissive() {
        return this.isEmissive;
    }

    @Override
    public boolean isProjected() {
        return this.isProjected;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    public static TextureSprite fromSprite(IIcon icon) {
        return new TextureSprite(icon);
    }

    public static Image fromImage(ResourceLocation location) {
        return new Image(location);
    }

    @Override
    public ResourceLocation location() {
        return this.location;
    }

    @Override
    public ITexture tinted(int index) {
        TextureProxy result = new TextureProxy(this);
        result.tintIndex = index;
        return result;
    }

    @Override
    public ITexture colored(double red, double green, double blue) {
        TextureProxy result = new TextureProxy(this);
        result.red = red;
        result.green = green;
        result.blue = blue;
        return result;
    }

    @Override
    public ITexture emissive() {
        TextureProxy result = new TextureProxy(this);
        result.isEmissive = true;
        return result;
    }

    @Override
    public ITexture projected() {
        TextureProxy result = new TextureProxy(this);
        result.isProjected = true;
        return result;
    }

    @Override
    public ITiledTexture tiled(int numRows, int numCols) {
        return new TextureTileSet(this, numRows, numCols);
    }
}

