/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.tile;

import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.Optional;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineAbstract;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineJet;
import de.katzenpapst.amunra.vec.Vector3int;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="CoFHAPI|energy")
public class TileEntityMothershipEngineBooster
extends TileBaseUniversalElectrical
implements IFluidHandler,
ISidedInventory,
IInventory,
IEnergyReceiver {
    public static ResourceLocation topFallback = new ResourceLocation("galacticraftasteroids", "textures/blocks/machine.png");
    public static ResourceLocation sideFallback = new ResourceLocation("galacticraftasteroids", "textures/blocks/machine_side.png");
    protected final String assetPrefix = "amunra";
    protected final String assetPath = "textures/blocks/";
    protected boolean masterPresent = false;
    protected int masterX;
    protected int masterY;
    protected int masterZ;
    protected Class<? extends TileEntityMothershipEngineAbstract> masterType = TileEntityMothershipEngineJet.class;

    public boolean isValidMaster(TileEntity tile) {
        return this.masterType.isInstance(tile);
    }

    public void reset() {
        this.masterPresent = false;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setMaster(int x, int y, int z) {
        this.masterX = x;
        this.masterY = y;
        this.masterZ = z;
        this.masterPresent = true;
    }

    public int getMasterX() {
        return this.masterX;
    }

    public int getMasterY() {
        return this.masterY;
    }

    public int getMasterZ() {
        return this.masterZ;
    }

    public void clearMaster() {
        this.masterPresent = false;
    }

    public boolean isMaster(int x, int y, int z) {
        return this.masterPresent && x == this.masterX && y == this.masterY && z == this.masterZ;
    }

    public Vector3int getMasterPosition() {
        return new Vector3int(this.masterX, this.masterY, this.masterZ);
    }

    public boolean hasMaster() {
        return this.getMasterTile() != null;
    }

    public void updateMaster(boolean rightNow) {
        TileEntityMothershipEngineAbstract jetTile;
        if (!this.masterPresent) {
            return;
        }
        TileEntity masterTile = this.field_145850_b.func_147438_o(this.masterX, this.masterY, this.masterZ);
        if (masterTile == null || !(masterTile instanceof TileEntityMothershipEngineAbstract) || !(jetTile = (TileEntityMothershipEngineAbstract)masterTile).isPartOfMultiBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.reset();
            return;
        }
        if (rightNow) {
            jetTile.updateMultiblock();
        } else {
            jetTile.scheduleUpdate();
        }
    }

    public Vector3int getPossibleNextBooster() {
        if (!this.hasMaster()) {
            return null;
        }
        if (this.field_145851_c == this.masterX) {
            if (this.field_145849_e < this.masterZ) {
                return new Vector3int(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            }
            if (this.field_145849_e > this.masterZ) {
                return new Vector3int(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            }
            return null;
        }
        if (this.field_145849_e == this.masterZ) {
            if (this.field_145851_c < this.masterX) {
                return new Vector3int(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            }
            if (this.field_145851_c > this.masterX) {
                return new Vector3int(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            }
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.masterPresent = compound.func_74767_n("hasMaster");
        this.masterX = compound.func_74762_e("masterX");
        this.masterY = compound.func_74762_e("masterY");
        this.masterZ = compound.func_74762_e("masterZ");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74757_a("hasMaster", this.masterPresent);
        compound.func_74768_a("masterX", this.masterX);
        compound.func_74768_a("masterY", this.masterY);
        compound.func_74768_a("masterZ", this.masterZ);
    }

    public TileEntityMothershipEngineAbstract getMasterTile() {
        if (!this.masterPresent) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(this.masterX, this.masterY, this.masterZ);
        if (!(tile instanceof TileEntityMothershipEngineAbstract)) {
            this.masterPresent = false;
            return null;
        }
        TileEntityMothershipEngineAbstract tileEngine = (TileEntityMothershipEngineAbstract)tile;
        return tileEngine;
    }

    public int func_70302_i_() {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return 0;
        }
        return tile.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotIn) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return null;
        }
        return tile.func_70301_a(slotIn);
    }

    public ItemStack func_70298_a(int index, int count) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return null;
        }
        return tile.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return null;
        }
        return tile.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return;
        }
        tile.func_70299_a(index, stack);
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.mothership.rocketJetEngine.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return 0;
        }
        return tile.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return false;
        }
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return false;
        }
        return tile.func_94041_b(index, stack);
    }

    public int[] func_94128_d(int p_94128_1_) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return new int[0];
        }
        return tile.func_94128_d(p_94128_1_);
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return false;
        }
        return tile.func_102007_a(p_102007_1_, p_102007_2_, p_102007_3_);
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return false;
        }
        return tile.func_102008_b(p_102008_1_, p_102008_2_, p_102008_3_);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return 0;
        }
        return tile.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return null;
        }
        return tile.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return null;
        }
        return tile.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return false;
        }
        return tile.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return false;
        }
        return tile.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return null;
        }
        return tile.getTankInfo(from);
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public ResourceLocation getBlockIconFromSide(int side) {
        if (side > 1) {
            return sideFallback;
        }
        return topFallback;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return EnumSet.noneOf(ForgeDirection.class);
        }
        return tile.getElectricalInputDirections();
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return false;
        }
        return tile.canConnect(direction, type);
    }

    public float receiveElectricity(ForgeDirection from, float receive, int tier, boolean doReceive) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return 0.0f;
        }
        return tile.receiveElectricity(from, receive, tier, doReceive);
    }

    public float provideElectricity(ForgeDirection from, float request, boolean doProvide) {
        return 0.0f;
    }

    public float getRequest(ForgeDirection direction) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return 0.0f;
        }
        return tile.getRequest(direction);
    }

    public float getProvide(ForgeDirection direction) {
        return 0.0f;
    }

    public int getTierGC() {
        return this.tierGC;
    }

    public void setTierGC(int newTier) {
        this.tierGC = newTier;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntityMothershipEngineAbstract tile = this.getMasterTile();
        if (tile == null) {
            return 0;
        }
        return tile.receiveEnergy(from, maxReceive, simulate);
    }
}

