/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.tile;

import cpw.mods.fml.relauncher.Side;
import de.katzenpapst.amunra.block.BlockMachineMeta;
import de.katzenpapst.amunra.block.SubBlockMachine;
import de.katzenpapst.amunra.block.machine.BlockIsotopeGenerator;
import de.katzenpapst.amunra.helper.CoordHelper;
import java.util.EnumSet;
import java.util.Objects;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityIsotopeGenerator
extends TileBaseUniversalElectricalSource
implements IPacketReceiver,
IDisableableMachine,
IInventory,
ISidedInventory,
IConnector {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    private ItemStack[] containingItems = new ItemStack[1];
    protected final int energyCapacity = 30000;
    protected float energyGeneration = 1.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float generateWatts = 0.0f;
    public static final int MAX_GENERATE_WATTS = 200;
    private boolean initialised = false;
    private SubBlockMachine subBlock = null;
    protected float generationBoost = -1.0f;

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    protected void init() {
        this.energyGeneration = ((BlockIsotopeGenerator)this.getSubBlock()).energyGeneration;
        this.storage.setMaxExtract(200.0f);
        this.storage.setMaxReceive(200.0f);
        Objects.requireNonNull(this);
        this.storage.setCapacity(30000.0f);
        this.initialised = true;
    }

    public SubBlockMachine getSubBlock() {
        if (this.subBlock == null) {
            this.subBlock = (SubBlockMachine)((BlockMachineMeta)this.func_145838_q()).getSubBlock(this.func_145832_p());
        }
        return this.subBlock;
    }

    public void func_145845_h() {
        if (!this.initialised) {
            this.init();
        }
        this.receiveEnergyGC(null, this.generateWatts, false);
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.recharge(this.containingItems[0]);
            if (this.getDisabled(0)) {
                this.generateWatts = 0.0f;
                this.generationBoost = -1.0f;
            } else {
                if (this.generationBoost == -1.0f || this.ticks % 20 == 0) {
                    this.generationBoost = this.getEnvironmentalEnergyBoost();
                }
                this.generateWatts = Math.min(this.energyGeneration * this.generationBoost, 200.0f);
            }
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
        }
        this.produce();
    }

    public float getEnvironmentalEnergyBoost() {
        float thermalLevel = 0.0f;
        if (this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider) {
            thermalLevel = ((IGalacticraftWorldProvider)this.field_145850_b.field_73011_w).getThermalLevelModifier();
        }
        float result = (float)Math.exp(-0.25 * (double)thermalLevel);
        return Math.min(result, 10.0f);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.storage.setCapacity(compound.func_74760_g("maxEnergy"));
        this.setDisabled(0, compound.func_74767_n("disabled"));
        this.disableCooldown = compound.func_74762_e("disabledCooldown");
        NBTTagList var2 = compound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.initialised = false;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74776_a("maxEnergy", this.getMaxEnergyStoredGC());
        compound.func_74768_a("disabledCooldown", this.disableCooldown);
        compound.func_74757_a("disabled", this.getDisabled(0));
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        compound.func_74782_a("Items", (NBTBase)list);
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        int metadata = this.getRotationMeta(this.func_145832_p());
        return EnumSet.of(CoordHelper.rotateForgeDirection(ForgeDirection.EAST, metadata), CoordHelper.rotateForgeDirection(ForgeDirection.WEST, metadata), CoordHelper.rotateForgeDirection(ForgeDirection.NORTH, metadata), ForgeDirection.UNKNOWN);
    }

    public int getRotationMeta(int meta) {
        return (meta & 0xC) >> 2;
    }

    public ForgeDirection getElectricalOutputDirectionMain() {
        int metadata = this.getRotationMeta(this.func_145832_p());
        return CoordHelper.rotateForgeDirection(ForgeDirection.EAST, metadata);
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || ForgeDirection.UNKNOWN.equals((Object)direction) || type != NetworkType.POWER) {
            return false;
        }
        return this.getElectricalOutputDirections().contains(direction);
    }

    public boolean canUpdate() {
        return true;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0};
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return this.func_94041_b(p_102007_1_, p_102007_2_);
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return p_102008_1_ == 0;
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.containingItems[slotIn];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack var3;
        if (this.containingItems[index] == null) {
            return null;
        }
        if (this.containingItems[index].field_77994_a <= count) {
            var3 = this.containingItems[index];
            this.containingItems[index] = null;
        } else {
            var3 = this.containingItems[index].func_77979_a(count);
            if (this.containingItems[index].field_77994_a == 0) {
                this.containingItems[index] = null;
            }
        }
        return var3;
    }

    public ItemStack func_70304_b(int index) {
        if (this.containingItems[index] != null) {
            ItemStack var2 = this.containingItems[index];
            this.containingItems[index] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containingItems[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)("tile." + this.getSubBlock().func_149739_a() + ".name"));
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && ItemElectricBase.isElectricItem((Item)stack.func_77973_b());
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }
}

