/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.mob;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class RobotVillagerProfession {
    protected ResourceLocation icon;
    protected String name;
    protected MerchantRecipeList merchantList;
    protected static final List<RobotVillagerProfession> professionRegistry = new ArrayList<RobotVillagerProfession>();

    public static int addProfession(RobotVillagerProfession prof) {
        professionRegistry.add(prof);
        return professionRegistry.size() - 1;
    }

    public static RobotVillagerProfession getProfession(int profession) {
        return professionRegistry.get(profession);
    }

    public static int getRandomProfession(Random rand) {
        return rand.nextInt(professionRegistry.size());
    }

    public RobotVillagerProfession(ResourceLocation icon, String name, MerchantRecipeList list) {
        this.icon = icon;
        this.name = name;
        this.merchantList = list;
    }

    public RobotVillagerProfession(ResourceLocation icon, String name) {
        this.icon = icon;
        this.name = name;
        this.merchantList = new MerchantRecipeList();
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public MerchantRecipeList getRecipeList() {
        return this.merchantList;
    }

    public RobotVillagerProfession addRecipe(MerchantRecipe recipe) {
        this.merchantList.add((Object)recipe);
        return this;
    }

    public RobotVillagerProfession addRecipe(ItemStack input1, ItemStack input2, ItemStack output) {
        this.merchantList.add((Object)new MerchantRecipe(input1, input2, output));
        return this;
    }

    public RobotVillagerProfession addRecipe(ItemStack input, ItemStack output) {
        this.merchantList.add((Object)new MerchantRecipe(input, output));
        return this;
    }

    public RobotVillagerProfession addRecipe(Item singleInputItem, int numEmeralds, Item singleOutputItem) {
        this.merchantList.add((Object)new MerchantRecipe(new ItemStack(singleInputItem, 1), new ItemStack(Items.field_151166_bC, numEmeralds), new ItemStack(singleOutputItem, 1)));
        return this;
    }
}

