/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.journeymap.drawsteps;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.integration.model.locations.UndergroundFluidChunkLocation;
import java.awt.geom.Point2D;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;

public class UndergroundFluidChunkDrawStep
implements DrawStep {
    private final UndergroundFluidChunkLocation undergroundFluidChunkLocation;

    public UndergroundFluidChunkDrawStep(UndergroundFluidChunkLocation undergroundFluidChunkLocation) {
        this.undergroundFluidChunkLocation = undergroundFluidChunkLocation;
    }

    public void draw(double draggedPixelX, double draggedPixelY, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
        int zoom = gridRenderer.getZoom();
        if (this.undergroundFluidChunkLocation.getFluidAmount() > 0 && zoom >= Config.minZoomLevelForUndergroundFluidDetails) {
            double blockSize = Math.pow(2.0, zoom);
            Point2D.Double blockAsPixel = gridRenderer.getBlockPixelInGrid(this.undergroundFluidChunkLocation.getBlockX(), this.undergroundFluidChunkLocation.getBlockZ());
            Point2D.Double pixel = new Point2D.Double(blockAsPixel.getX() + draggedPixelX, blockAsPixel.getY() + draggedPixelY);
            float alpha = (float)(this.undergroundFluidChunkLocation.getFluidAmount() - this.undergroundFluidChunkLocation.getMinAmountInField()) / (float)(this.undergroundFluidChunkLocation.getMaxAmountInField() - this.undergroundFluidChunkLocation.getMinAmountInField() + 1);
            alpha *= alpha * 204.0f;
            DrawUtil.drawRectangle((double)pixel.getX(), (double)pixel.getY(), (double)(16.0 * blockSize), (double)(16.0 * blockSize), (int)this.undergroundFluidChunkLocation.getFluid().getColor(), (int)((int)alpha));
            if (this.undergroundFluidChunkLocation.getFluidAmount() >= this.undergroundFluidChunkLocation.getMaxAmountInField()) {
                int borderColor = 16766720;
                int borderAlpha = 204;
                DrawUtil.drawRectangle((double)pixel.getX(), (double)pixel.getY(), (double)(15.0 * blockSize), (double)blockSize, (int)16766720, (int)204);
                DrawUtil.drawRectangle((double)(pixel.getX() + 15.0 * blockSize), (double)pixel.getY(), (double)blockSize, (double)(15.0 * blockSize), (int)16766720, (int)204);
                DrawUtil.drawRectangle((double)(pixel.getX() + 1.0 * blockSize), (double)(pixel.getY() + 15.0 * blockSize), (double)(15.0 * blockSize), (double)blockSize, (int)16766720, (int)204);
                DrawUtil.drawRectangle((double)pixel.getX(), (double)(pixel.getY() + 1.0 * blockSize), (double)blockSize, (double)(15.0 * blockSize), (int)16766720, (int)204);
            }
            DrawUtil.drawLabel((String)this.undergroundFluidChunkLocation.getFluidAmountFormatted(), (double)(pixel.getX() + 13.0 * blockSize), (double)(pixel.getY() + 13.0 * blockSize), (DrawUtil.HAlign)DrawUtil.HAlign.Left, (DrawUtil.VAlign)DrawUtil.VAlign.Above, (Integer)0, (int)180, (Integer)0xFFFFFF, (int)255, (double)fontScale, (boolean)false, (double)rotation);
        }
    }
}

