/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration.tc;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.IWarpingGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;

public class VisCraftingHelper {
    public static final VisCraftingHelper INSTANCE = new VisCraftingHelper();
    private ItemStack craftingScepter = null;

    private VisCraftingHelper() {
    }

    public float calculateArmorDiscount(IInventory inventory, int firstSlotIndex, int slotCount, Aspect aspect) {
        float discount = 0.0f;
        for (int index = 0; index < slotCount; ++index) {
            ItemStack armor = inventory.func_70301_a(firstSlotIndex + index);
            if (armor == null || !(armor.func_77973_b() instanceof IVisDiscountGear)) continue;
            try {
                discount += (float)((IVisDiscountGear)armor.func_77973_b()).getVisDiscount(armor, null, aspect) / 100.0f;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return discount;
    }

    public int calculateArmorWarp(IInventory inventory, int firstSlotIndex, int slotCount) {
        int warp = 0;
        for (int index = 0; index < slotCount; ++index) {
            ItemStack armor = inventory.func_70301_a(firstSlotIndex + index);
            if (armor == null || !(armor.func_77973_b() instanceof IWarpingGear)) continue;
            try {
                warp += ((IWarpingGear)armor.func_77973_b()).getWarp(armor, null);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return warp;
    }

    public ItemStack getCraftingScepter() {
        if (this.craftingScepter == null) {
            this.craftingScepter = new ItemStack(ConfigItems.itemWandCasting, 1, Short.MAX_VALUE);
            ((ItemWandCasting)this.craftingScepter.func_77973_b()).setCap(this.craftingScepter, ConfigItems.WAND_CAP_THAUMIUM);
            ((ItemWandCasting)this.craftingScepter.func_77973_b()).setRod(this.craftingScepter, ConfigItems.WAND_ROD_SILVERWOOD);
            this.craftingScepter.func_77983_a("sceptre", (NBTBase)new NBTTagByte(1));
            for (Aspect aspect : Aspect.getPrimalAspects()) {
                ((ItemWandCasting)this.craftingScepter.func_77973_b()).addVis(this.craftingScepter, aspect, ((ItemWandCasting)this.craftingScepter.func_77973_b()).getMaxVis(this.craftingScepter), true);
            }
        }
        return this.craftingScepter;
    }

    public float getScepterVisModifier(Aspect aspect) {
        if (this.craftingScepter == null) {
            this.getCraftingScepter();
        }
        return ((ItemWandCasting)this.craftingScepter.func_77973_b()).getConsumptionModifier(this.craftingScepter, null, aspect, true);
    }
}

