/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.widget;

import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;
import thaumicenergistics.api.gui.IWidgetHost;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.client.gui.ThEGuiHelper;
import thaumicenergistics.client.gui.widget.ThEWidget;
import thaumicenergistics.common.integration.tc.AspectHooks;
import thaumicenergistics.common.storage.AspectStack;

@SideOnly(value=Side.CLIENT)
public abstract class AspectWidgetBase
extends ThEWidget {
    private static final ResourceLocation UNKNOWN_TEXTURE = new ResourceLocation("thaumcraft", "textures/aspects/_unknown.png");
    private final IAspectStack aspectStack;
    protected boolean hasDiscovered = false;
    protected String aspectName = "";
    protected String aspectDescription = "";
    protected String aspectFootnote = "";
    private EntityPlayer player;
    private byte[] aspectColorBytes;

    public AspectWidgetBase(IWidgetHost hostGui, IAspectStack stack, int xPos, int yPos, EntityPlayer player) {
        super(hostGui, xPos, yPos);
        this.player = player;
        this.aspectStack = new AspectStack();
        this.setAspect(stack);
    }

    protected void clearStack(boolean doUpdate) {
        this.aspectStack.setAll(null, 0L, false);
        this.aspectName = "";
        this.aspectDescription = "";
        this.aspectFootnote = "";
        this.hasDiscovered = false;
        if (doUpdate) {
            this.onStackChanged();
        }
    }

    protected void drawAspect() {
        if (!this.aspectStack.hasAspect()) {
            return;
        }
        if (this.hasDiscovered) {
            UtilsFX.drawTag((int)(this.xPosition + 1), (int)(this.yPosition + 1), (Aspect)this.aspectStack.getAspect(), (float)0.0f, (int)0, (double)this.field_73735_i);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(UNKNOWN_TEXTURE);
            GL11.glColor4ub((byte)this.aspectColorBytes[1], (byte)this.aspectColorBytes[2], (byte)this.aspectColorBytes[3], (byte)this.aspectColorBytes[0]);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            UtilsFX.drawTexturedQuadFull((int)(this.xPosition + 1), (int)(this.yPosition + 1), (double)this.field_73735_i);
            GL11.glDisable((int)3042);
        }
    }

    protected void onStackChanged() {
        if (this.aspectStack.hasAspect()) {
            this.aspectName = this.aspectStack.getAspectName(this.player);
            this.hasDiscovered = this.aspectStack.hasPlayerDiscovered(this.player);
            if (this.hasDiscovered) {
                this.aspectDescription = this.aspectStack.getAspectDescription();
                ModContainer mod = AspectHooks.aspectToMod.getOrDefault(this.aspectStack.getAspect(), null);
                this.aspectFootnote = mod != null ? mod.getName() : "Unknown";
            } else {
                this.aspectDescription = this.aspectName;
                this.aspectFootnote = "Unknown";
            }
            this.aspectColorBytes = ThEGuiHelper.INSTANCE.convertPackedColorToARGBb(this.aspectStack.getAspect().getColor());
            this.aspectColorBytes[0] = -1;
        } else {
            this.clearStack(false);
        }
    }

    public void clearWidget() {
        this.clearStack(true);
    }

    public long getAmount() {
        return this.aspectStack.getStackSize();
    }

    public Aspect getAspect() {
        return this.aspectStack.getAspect();
    }

    public boolean getCraftable() {
        return this.aspectStack.getCraftable();
    }

    public IAspectStack getStack() {
        return this.aspectStack;
    }

    @Override
    public void getTooltip(List<String> tooltip) {
        if (this.hasAspect()) {
            tooltip.add(this.aspectName);
            tooltip.add(EnumChatFormatting.GRAY.toString() + this.aspectDescription);
            tooltip.add(EnumChatFormatting.DARK_PURPLE.toString() + EnumChatFormatting.ITALIC.toString() + this.aspectFootnote);
        }
    }

    public boolean hasAspect() {
        return this.aspectStack.hasAspect();
    }

    public void setAspect(Aspect aspect, long amount, boolean isCraftable) {
        this.aspectStack.setAll(aspect, amount, isCraftable);
        this.onStackChanged();
    }

    public void setAspect(IAspectStack stack) {
        this.aspectStack.setAll(stack);
        this.onStackChanged();
    }
}

