/*
 * Decompiled with CFR 0.152.
 */
package net.glease.structurecompat;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.alignment.constructable.IMultiblockInfoContainer;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import java.util.Map;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.alpha.TileBlastFurnace;
import mods.railcraft.common.blocks.machine.alpha.TileCokeOven;
import mods.railcraft.common.blocks.machine.alpha.TileRockCrusher;
import mods.railcraft.common.blocks.machine.alpha.TileSteamOven;
import mods.railcraft.common.blocks.machine.alpha.TileTankWater;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFireboxFluid;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFireboxSolid;
import net.glease.structurecompat.Compat;
import net.glease.structurecompat.StructureUtilityExt;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

@Compat(value={"Railcraft"})
public class CompatRailcraft {
    public static final int[][] BOILER_DIMENSIONS = new int[][]{{1, 1}, {2, 2}, {2, 3}, {3, 2}, {3, 3}, {3, 4}};

    public CompatRailcraft() {
        CompatRailcraft.registerBoilerStructureInfo();
        String[][] hollow3x3 = new String[][]{{"     ", " xxx ", " xxx ", " xxx ", "     "}, {" xxx ", "xbbbx", "xbbbx", "xbbbx", " xxx "}, {" xxx ", "xbbbx", "xb-bx", "xbbbx", " xxx "}, {" xxx ", "xbbbx", "xbbbx", "xbbbx", " xxx "}, {"     ", " xxx ", " xxx ", " xxx ", "     "}};
        IMultiblockInfoContainer.registerTileClass(TileCokeOven.class, new SimpleMultiblockInfoContainer(IStructureDefinition.builder().addShape("main", hollow3x3).addElement('b', StructureUtility.ofBlock((Block)RailcraftBlocks.getBlockMachineAlpha(), (int)EnumMachineAlpha.COKE_OVEN.ordinal())).addElement('x', StructureUtilityExt.notBlock(RailcraftBlocks.getBlockMachineAlpha(), EnumMachineAlpha.COKE_OVEN.ordinal())).build(), 2, 2, 1, true, "Coke Oven"));
        IMultiblockInfoContainer.registerTileClass(TileTankWater.class, new SimpleMultiblockInfoContainer(IStructureDefinition.builder().addShape("main", hollow3x3).addElement('b', StructureUtility.ofBlock((Block)RailcraftBlocks.getBlockMachineAlpha(), (int)EnumMachineAlpha.TANK_WATER.ordinal())).addElement('x', StructureUtilityExt.notBlock(RailcraftBlocks.getBlockMachineAlpha(), EnumMachineAlpha.TANK_WATER.ordinal())).build(), 2, 2, 1, true, "Water Tank"));
        IMultiblockInfoContainer.registerTileClass(TileSteamOven.class, new SimpleMultiblockInfoContainer(IStructureDefinition.builder().addShape("main", (String[][])new String[][]{{"    ", " xx ", " xx ", "    "}, {" xx ", "xoox", "xoox", " xx "}, {" xx ", "xoox", "xoox", " xx "}, {"    ", " xx ", " xx ", "    "}}).addElement('o', StructureUtility.ofBlock((Block)RailcraftBlocks.getBlockMachineAlpha(), (int)EnumMachineAlpha.STEAM_OVEN.ordinal())).addElement('x', StructureUtilityExt.notBlock(RailcraftBlocks.getBlockMachineAlpha(), EnumMachineAlpha.STEAM_OVEN.ordinal())).build(), 1, 2, 1, true, "Steam Oven"));
        IMultiblockInfoContainer.registerTileClass(TileRockCrusher.class, new SimpleMultiblockInfoContainer(IStructureDefinition.builder().addShape("main", (String[][])new String[][]{{"    ", " xxx ", " xxx ", "    "}, {" xx ", "xcccx", "xcccx", " xx "}, {" xx ", "xcccx", "xcccx", " xx "}, {"    ", " xxx ", " xxx ", "    "}}).addElement('c', StructureUtility.ofBlock((Block)RailcraftBlocks.getBlockMachineAlpha(), (int)EnumMachineAlpha.ROCK_CRUSHER.ordinal())).addElement('x', StructureUtilityExt.notBlock(RailcraftBlocks.getBlockMachineAlpha(), EnumMachineAlpha.ROCK_CRUSHER.ordinal())).build(), 2, 2, 1, "Rock Crusher"));
        IMultiblockInfoContainer.registerTileClass(TileBlastFurnace.class, new SimpleMultiblockInfoContainer(IStructureDefinition.builder().addShape("main", (String[][])new String[][]{{"     ", " xxx ", " xxx ", " xxx ", " xxx ", "     "}, {" xxx ", "xbbbx", "xbbbx", "xbbbx", "xbbbx", " xxx "}, {" xxx ", "xbbbx", "xb-bx", "xb-bx", "xbbbx", " xxx "}, {" xxx ", "xbbbx", "xbbbx", "xbbbx", "xbbbx", " xxx "}, {"     ", " xxx ", " xxx ", " xxx ", " xxx ", "     "}}).addElement('b', StructureUtility.ofBlock((Block)RailcraftBlocks.getBlockMachineAlpha(), (int)EnumMachineAlpha.BLAST_FURNACE.ordinal())).addElement('x', StructureUtilityExt.notBlock(RailcraftBlocks.getBlockMachineAlpha(), EnumMachineAlpha.BLAST_FURNACE.ordinal())).build(), 2, 4, 1, "Blast Furnace"));
    }

    private static void registerBoilerStructureInfo() {
        String solidPrefix = "st";
        String fluidPrefix = "ft";
        StructureDefinition.Builder b = IStructureDefinition.builder();
        int[][] ints = BOILER_DIMENSIONS;
        int intsLength = ints.length;
        for (int i2 = 0; i2 < intsLength; ++i2) {
            int[] dimension = ints[i2];
            String[][] shape1 = new String[dimension[1]][];
            String[][] shape2 = null;
            for (int i1 = 0; i1 < dimension[1]; ++i1) {
                shape1[i1] = new String[dimension[0] + 1];
                for (int i22 = 0; i22 < dimension[0]; ++i22) {
                    shape1[i1][i22] = Strings.repeat((String)"b", (int)dimension[1]);
                }
                shape2 = (String[][])shape1.clone();
                shape1[i1][dimension[0]] = Strings.repeat((String)"f", (int)dimension[1]);
                shape2[i1][dimension[0]] = Strings.repeat((String)"F", (int)dimension[1]);
            }
            b.addShape(solidPrefix + i2, shape1);
            b.addShape(fluidPrefix + i2, shape2);
        }
        Block blockMachineBeta = RailcraftBlocks.getBlockMachineBeta();
        IStructureDefinition structureBoiler = b.addElement('f', StructureUtility.ofBlock((Block)blockMachineBeta, (int)EnumMachineBeta.BOILER_FIREBOX_SOLID.ordinal())).addElement('F', StructureUtility.ofBlock((Block)blockMachineBeta, (int)EnumMachineBeta.BOILER_FIREBOX_FLUID.ordinal())).addElement('b', (IStructureElement)StructureUtility.partitionBy((t, i) -> ChannelDataAccessor.getChannelData((ItemStack)i, (String)"boiler") <= 1, (Map)ImmutableMap.of((Object)true, (Object)StructureUtility.ofBlock((Block)blockMachineBeta, (int)EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.ordinal()), (Object)false, (Object)StructureUtility.ofBlock((Block)blockMachineBeta, (int)EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.ordinal())))).build();
        IMultiblockInfoContainer.registerTileClass(TileBoilerFireboxFluid.class, (IMultiblockInfoContainer)new BoilerMultiblockInfoContainer((IStructureDefinition<TileBoilerFirebox>)structureBoiler, fluidPrefix));
        IMultiblockInfoContainer.registerTileClass(TileBoilerFireboxSolid.class, (IMultiblockInfoContainer)new BoilerMultiblockInfoContainer((IStructureDefinition<TileBoilerFirebox>)structureBoiler, solidPrefix));
    }

    private static ExtendedFacing noSideWay(ExtendedFacing aSide) {
        return aSide.getDirection().offsetY != 0 ? ExtendedFacing.DEFAULT : aSide;
    }

    private static class BoilerMultiblockInfoContainer
    implements IMultiblockInfoContainer<TileBoilerFirebox> {
        private final IStructureDefinition<TileBoilerFirebox> structureBoiler;
        private final String piecePrefix;

        public BoilerMultiblockInfoContainer(IStructureDefinition<TileBoilerFirebox> structureBoiler, String piecePrefix) {
            this.structureBoiler = structureBoiler;
            this.piecePrefix = piecePrefix;
        }

        public void construct(ItemStack stackSize, boolean hintsOnly, TileBoilerFirebox ctx, ExtendedFacing aSide) {
            int width = ChannelDataAccessor.getChannelData((ItemStack)stackSize, (String)"width");
            int height = ChannelDataAccessor.getChannelData((ItemStack)stackSize, (String)"height");
            int boilerDimensionsLength = BOILER_DIMENSIONS.length;
            for (int i = 0; i < boilerDimensionsLength; ++i) {
                int[] dimension = BOILER_DIMENSIONS[i];
                if (dimension[0] != width || dimension[1] != height) continue;
                this.structureBoiler.buildOrHints((Object)ctx, stackSize, this.piecePrefix + i, ctx.func_145831_w(), CompatRailcraft.noSideWay(aSide), ctx.getX(), ctx.getY(), ctx.getZ(), width / 2, height, 0, hintsOnly);
                return;
            }
        }

        public int survivalConstruct(ItemStack stackSize, int elementBudge, ISurvivalBuildEnvironment env, TileBoilerFirebox ctx, ExtendedFacing aSide) {
            int width = ChannelDataAccessor.getChannelData((ItemStack)stackSize, (String)"width");
            int height = ChannelDataAccessor.getChannelData((ItemStack)stackSize, (String)"height");
            int boilerDimensionsLength = BOILER_DIMENSIONS.length;
            for (int i = 0; i < boilerDimensionsLength; ++i) {
                int[] dimension = BOILER_DIMENSIONS[i];
                if (dimension[0] != width || dimension[1] != height) continue;
                return this.structureBoiler.survivalBuild((Object)ctx, stackSize, this.piecePrefix + i, ctx.func_145831_w(), CompatRailcraft.noSideWay(aSide), ctx.getX(), ctx.getY(), ctx.getZ(), width / 2, height, 0, elementBudge, env, false);
            }
            env.getActor().func_145747_a((IChatComponent)new ChatComponentTranslation("structureinfo.railcraft.boiler.error.invalid_dimension", new Object[]{width, height}));
            return -1;
        }

        public String[] getDescription(ItemStack stackSize) {
            return new String[]{StatCollector.func_74838_a((String)"structureinfo.railcraft.boiler.0"), StatCollector.func_74838_a((String)"structureinfo.railcraft.boiler.1"), StatCollector.func_74838_a((String)"structureinfo.railcraft.boiler.2"), StatCollector.func_74838_a((String)"structureinfo.railcraft.boiler.3"), StatCollector.func_74838_a((String)"structureinfo.railcraft.boiler.4"), StatCollector.func_74838_a((String)"structureinfo.railcraft.boiler.5")};
        }
    }

    private static class SimpleMultiblockInfoContainer<T extends TileEntity>
    implements IMultiblockInfoContainer<T> {
        public static final String MAIN_PIECE_NAME = "main";
        private final IStructureDefinition<? super T> structrue;
        private final String[] desc;
        private final int offsetA;
        private final int offsetB;
        private final int offsetC;
        private final boolean allowSideway;

        public SimpleMultiblockInfoContainer(IStructureDefinition<? super T> structrue, int offsetA, int offsetB, int offsetC, String ... desc) {
            this(structrue, offsetA, offsetB, offsetC, false, desc);
        }

        public SimpleMultiblockInfoContainer(IStructureDefinition<? super T> structrue, int offsetA, int offsetB, int offsetC, boolean allowSideway, String ... desc) {
            this.structrue = structrue;
            this.allowSideway = allowSideway;
            this.desc = desc;
            this.offsetA = offsetA;
            this.offsetB = offsetB;
            this.offsetC = offsetC;
        }

        public void construct(ItemStack stackSize, boolean hintsOnly, T ctx, ExtendedFacing aSide) {
            this.structrue.buildOrHints(ctx, stackSize, MAIN_PIECE_NAME, ctx.func_145831_w(), this.allowSideway ? aSide : CompatRailcraft.noSideWay(aSide), ((TileEntity)ctx).field_145851_c, ((TileEntity)ctx).field_145848_d, ((TileEntity)ctx).field_145849_e, this.offsetA, this.offsetB, this.offsetC, hintsOnly);
        }

        public int survivalConstruct(ItemStack stackSize, int elementBudge, ISurvivalBuildEnvironment env, T ctx, ExtendedFacing aSide) {
            return this.structrue.survivalBuild(ctx, stackSize, MAIN_PIECE_NAME, ctx.func_145831_w(), this.allowSideway ? aSide : CompatRailcraft.noSideWay(aSide), ((TileEntity)ctx).field_145851_c, ((TileEntity)ctx).field_145848_d, ((TileEntity)ctx).field_145849_e, this.offsetA, this.offsetB, this.offsetC, elementBudge, env, false);
        }

        public String[] getDescription(ItemStack stackSize) {
            return this.desc;
        }
    }
}

