/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.shapes;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.IShape;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class RectHollow
implements IShape {
    private Coord start;
    private Coord end;

    public RectHollow(Coord start, Coord end) {
        this.start = start;
        this.end = end;
    }

    public static void fill(IWorldEditor editor, Random rand, Coord start, Coord end, IBlockFactory block) {
        RectHollow.fill(editor, rand, start, end, block, true, true);
    }

    public static void fill(IWorldEditor editor, Random rand, Coord start, Coord end, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        RectHollow rect = new RectHollow(start, end);
        rect.fill(editor, rand, block, fillAir, replaceSolid);
    }

    @Override
    public void fill(IWorldEditor editor, Random rand, IBlockFactory block) {
        this.fill(editor, rand, block, true, true);
    }

    @Override
    public void fill(IWorldEditor editor, Random rand, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        for (Coord c : this) {
            block.set(editor, rand, c, fillAir, replaceSolid);
        }
        Coord innerStart = new Coord(this.start);
        Coord innerEnd = new Coord(this.end);
        Coord.correct(innerStart, innerEnd);
        innerStart.add(new Coord(1, 1, 1));
        innerEnd.add(new Coord(-1, -1, -1));
        RectSolid.fill(editor, rand, innerStart, innerEnd, BlockType.get(BlockType.AIR));
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> coords = new ArrayList<Coord>();
        for (Coord c : this) {
            coords.add(c);
        }
        return coords;
    }

    @Override
    public Iterator<Coord> iterator() {
        return new RectHollowIterator(this.start, this.end);
    }

    private class RectHollowIterator
    implements Iterator<Coord> {
        Coord cursor;
        Coord c1;
        Coord c2;

        public RectHollowIterator(Coord c1, Coord c2) {
            this.c1 = new Coord(c1);
            this.c2 = new Coord(c2);
            Coord.correct(this.c1, this.c2);
            this.cursor = new Coord(this.c1);
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() <= this.c2.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = new Coord(this.cursor);
            if (this.cursor.getZ() == this.c2.getZ() && this.cursor.getX() == this.c2.getX()) {
                this.cursor = new Coord(this.c1.getX(), this.cursor.getY(), this.c1.getZ());
                this.cursor.add(Cardinal.UP);
                return toReturn;
            }
            if (this.cursor.getX() == this.c2.getX()) {
                this.cursor = new Coord(this.c1.getX(), this.cursor.getY(), this.cursor.getZ());
                this.cursor.add(Cardinal.SOUTH);
                return toReturn;
            }
            if (this.cursor.getY() != this.c1.getY() && this.cursor.getY() != this.c2.getY() && this.cursor.getZ() != this.c1.getZ() && this.cursor.getZ() != this.c2.getZ() && this.cursor.getX() == this.c1.getX()) {
                this.cursor.add(Cardinal.EAST, this.c2.getX() - this.c1.getX());
            } else {
                this.cursor.add(Cardinal.EAST);
            }
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

