/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.tileentity;

import com.google.common.hash.Hashing;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import li.cil.oc.Settings;
import li.cil.oc.api.Network;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mindrot.jbcrypt.BCrypt;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.tileentity.TileEntityMachineBase;

public class TileEntityDataBlock
extends TileEntityMachineBase
implements Environment {
    protected ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(TileEntityDataBlock.getComponentName()).withConnector(32.0).create();
    private ManagedEnvironment oc_fs;

    public TileEntityDataBlock() {
        if (this.node() != null) {
            this.initOCFilesystem();
        }
    }

    private void initOCFilesystem() {
        this.oc_fs = li.cil.oc.api.FileSystem.asManagedEnvironment((FileSystem)li.cil.oc.api.FileSystem.fromClass(OpenSecurity.class, (String)"opensecurity", (String)"/lua/datablock/"), (String)"datablock");
        ((Component)this.oc_fs.node()).setVisibility(Visibility.Neighbors);
    }

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    private static String getComponentName() {
        return "os_datablock";
    }

    public void onConnect(Node node) {
        if (node.host() instanceof Context) {
            node.connect(this.oc_fs.node());
        }
    }

    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            node.disconnect(this.oc_fs.node());
        } else if (node == this.node) {
            this.oc_fs.node().remove();
        }
    }

    public void onMessage(Message arg0) {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
        if (this.oc_fs != null && this.oc_fs.node() != null) {
            this.oc_fs.node().load(nbt.func_74775_l("oc:fs"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        if (this.oc_fs != null && this.oc_fs.node() != null) {
            NBTTagCompound fsNbt = new NBTTagCompound();
            this.oc_fs.node().save(fsNbt);
            nbt.func_74782_a("oc:fs", (NBTBase)fsNbt);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.node != null && this.node.network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    @Callback
    public Object[] greet(Context context, Arguments args) {
        return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
    }

    @Callback(direct=true, doc="function():number -- The maximum size of data that can be passed to other functions of the card.")
    public Object[] getLimit(Context context, Arguments args) {
        return new Object[]{Settings.get().dataCardHardLimit()};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- Applies base64 encoding to the data.")
    public Object[] encode64(Context context, Arguments args) throws Exception {
        return new Object[]{Base64.encodeBase64((byte[])this.checkLimits(context, args, Settings.get().dataCardComplex()))};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- Applies base64 decoding to the data.")
    public Object[] decode64(Context context, Arguments args) throws Exception {
        return new Object[]{Base64.decodeBase64((byte[])this.checkLimits(context, args, Settings.get().dataCardComplex()))};
    }

    @Callback(direct=true, limit=6, doc="function(data:string):string -- Applies deflate compression to the data.")
    public Object[] deflate(Context context, Arguments args) throws Exception {
        byte[] data = this.checkLimits(context, args, Settings.get().dataCardComplex());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        DeflaterOutputStream deos = new DeflaterOutputStream((OutputStream)baos);
        deos.write(data);
        deos.finish();
        deos.close();
        return new Object[]{baos.toByteArray()};
    }

    @Callback(direct=true, limit=6, doc="function(data:string):string -- Applies inflate decompression to the data.")
    public Object[] inflate(Context context, Arguments args) throws Exception {
        byte[] data = this.checkLimits(context, args, Settings.get().dataCardComplex());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        InflaterOutputStream inos = new InflaterOutputStream((OutputStream)baos);
        inos.write(data);
        inos.finish();
        inos.close();
        return new Object[]{baos.toByteArray()};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- Computes SHA2-256 hash of the data. Result is in binary format.")
    public Object[] sha256(Context context, Arguments args) throws Exception {
        byte[] data = this.checkLimits(context, args, Settings.get().dataCardSimple());
        return new Object[]{Hashing.sha256().hashBytes(data).asBytes()};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- function(data:string):string -- Computes MD5 hash of the data. Result is in binary format")
    public Object[] md5(Context context, Arguments args) throws Exception {
        byte[] data = this.checkLimits(context, args, Settings.get().dataCardSimple());
        return new Object[]{Hashing.md5().hashBytes(data).asBytes()};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- Computes CRC-32 hash of the data. Result is in binary format")
    public Object[] crc32(Context context, Arguments args) throws Exception {
        byte[] data = this.checkLimits(context, args, Settings.get().dataCardSimple());
        return new Object[]{Hashing.crc32().hashBytes(data).asBytes()};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- Applies rot13 to the data. ")
    public Object[] rot13(Context context, Arguments args) throws Exception {
        return new Object[]{TileEntityDataBlock.rot13(args.checkString(0))};
    }

    @Callback(direct=true, limit=32, doc="function(plain-text:string, optional rounds:int):string -- Computes the bCryptHash of the input plaintext, optionally supply rounds (4-15)")
    public Object[] bCryptHash(Context context, Arguments args) throws Exception {
        int rounds = (int)args.optDouble(1, 10.0);
        if (rounds < 4) {
            rounds = 4;
        } else if (rounds > 15) {
            rounds = 15;
        }
        String hashed = BCrypt.hashpw((String)args.checkString(0), (String)BCrypt.gensalt((int)rounds));
        return new Object[]{hashed};
    }

    @Callback(direct=true, limit=32, doc="function(plain-text:string, hash:string):boolean -- Checks bCrypt input vs hash supplied")
    public Object[] bCryptCheck(Context context, Arguments args) throws Exception {
        return new Object[]{BCrypt.checkpw((String)args.checkString(0), (String)args.checkString(1))};
    }

    private byte[] checkLimits(Context context, Arguments args, Double cost) throws Exception {
        byte[] data = args.checkByteArray(0);
        if (data.length > Settings.get().dataCardHardLimit()) {
            throw new IllegalArgumentException("data size limit exceeded");
        }
        if (!this.node.tryChangeBuffer(-cost.doubleValue())) {
            throw new Exception("not enough energy");
        }
        if (data.length > Settings.get().dataCardSoftLimit()) {
            context.pause(Settings.get().dataCardTimeout());
        }
        return data;
    }

    public static String rot13(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

