/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.drivers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.DriverItem;
import li.cil.oc.common.entity.Drone;
import li.cil.oc.common.inventory.Inventory;
import li.cil.oc.common.item.TabletWrapper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import pcl.opensecurity.ContentRegistry;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.items.ItemRFIDCard;

public class RFIDReaderCardDriver
extends DriverItem {
    public RFIDReaderCardDriver() {
        super(new ItemStack[]{new ItemStack(ContentRegistry.rfidReaderCardItem)});
    }

    public ManagedEnvironment createEnvironment(ItemStack arg0, EnvironmentHost arg1) {
        if (arg1 instanceof TileEntity) {
            return new Environment(arg1);
        }
        if (arg1 instanceof TabletWrapper) {
            return new Environment(arg1);
        }
        return null;
    }

    public String slot(ItemStack stack) {
        return "card";
    }

    public class Environment
    extends li.cil.oc.api.prefab.ManagedEnvironment {
        public String data = null;
        protected EnvironmentHost container = null;
        protected ComponentConnector node = (ComponentConnector)Network.newNode((li.cil.oc.api.network.Environment)this, (Visibility)Visibility.Network).withComponent("os_rfidreader").withConnector(32.0).create();

        public Node node() {
            return this.node;
        }

        public Environment(EnvironmentHost arg1) {
            this.container = arg1;
            this.setNode((Node)this.node);
        }

        @Callback
        public Object[] greet(Context context, Arguments args) {
            return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
        }

        @Callback(doc="function(optional:int:range):string; pushes a signal \"rfidData\" for each found rfid on all players in range, optional set range.")
        public Object[] scan(Context context, Arguments args) throws Exception {
            double range = args.optDouble(0, (double)OpenSecurity.rfidRange);
            if (range > (double)OpenSecurity.rfidRange) {
                range = OpenSecurity.rfidRange;
            }
            if (this.node.changeBuffer(-5.0 * (range /= 2.0)) == 0.0) {
                return new Object[]{this.scan(range)};
            }
            throw new Exception("Not enough power in OC Network.");
        }

        private HashMap<String, Object> info(Entity entity, String data, String uuid, boolean locked) {
            HashMap<String, Object> value = new HashMap<String, Object>();
            double rangeToEntity = entity.func_70011_f(this.container.xPosition(), this.container.yPosition(), this.container.zPosition());
            String name = entity instanceof EntityPlayerMP ? ((EntityPlayer)entity).getDisplayName() : entity.func_70005_c_();
            this.node.sendToReachable("computer.signal", new Object[]{"rfidData", name, rangeToEntity, data, uuid});
            value.put("name", name);
            value.put("range", rangeToEntity);
            value.put("data", data);
            value.put("uuid", uuid);
            value.put("locked", locked);
            return value;
        }

        public Map<Integer, HashMap<String, Object>> scan(double range) {
            HashMap<Integer, HashMap<String, Object>> output = new HashMap<Integer, HashMap<String, Object>>();
            int index = 1;
            List e = this.container.world().func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.container.xPosition() - range), (double)(this.container.yPosition() - range), (double)(this.container.zPosition() - range), (double)(this.container.xPosition() + range), (double)(this.container.yPosition() + range), (double)(this.container.zPosition() + range)));
            if (!e.isEmpty()) {
                for (int i = 0; i <= e.size() - 1; ++i) {
                    NBTTagCompound tag;
                    String localUUID;
                    ItemStack st;
                    int k;
                    int size;
                    EntityPlayer em;
                    Entity entity = (Entity)e.get(i);
                    if (entity instanceof EntityPlayerMP) {
                        em = (EntityPlayer)entity;
                        ItemStack[] playerInventory = em.field_71071_by.field_70462_a;
                        size = playerInventory.length;
                        for (k = 0; k < size; ++k) {
                            st = em.field_71071_by.func_70301_a(k);
                            if (st == null || !(st.func_77973_b() instanceof ItemRFIDCard) || st.field_77990_d == null || !st.field_77990_d.func_74764_b("data")) continue;
                            localUUID = !OpenSecurity.ignoreUUIDs ? st.field_77990_d.func_74779_i("uuid") : "-1";
                            output.put(index++, this.info(entity, st.field_77990_d.func_74779_i("data"), localUUID, st.field_77990_d.func_74767_n("locked")));
                        }
                    } else if (entity instanceof Drone) {
                        em = (Drone)entity;
                        Inventory droneInventory = em.mainInventory();
                        size = em.inventorySize();
                        for (k = 0; k < size; ++k) {
                            st = droneInventory.func_70301_a(k);
                            if (st == null || !(st.func_77973_b() instanceof ItemRFIDCard) || st.field_77990_d == null || !st.field_77990_d.func_74764_b("data")) continue;
                            localUUID = !OpenSecurity.ignoreUUIDs ? st.field_77990_d.func_74779_i("uuid") : "-1";
                            output.put(index++, this.info(entity, st.field_77990_d.func_74779_i("data"), localUUID, st.field_77990_d.func_74767_n("locked")));
                        }
                    }
                    if (!(tag = entity.getEntityData().func_74775_l("rfidData")).func_74764_b("data")) continue;
                    String localUUID2 = !OpenSecurity.ignoreUUIDs ? tag.func_74779_i("uuid") : "-1";
                    output.put(index++, this.info(entity, tag.func_74779_i("data"), localUUID2, tag.func_74767_n("locked")));
                }
            }
            return output;
        }
    }
}

