/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.math.CrossAxisAlignment;
import com.gtnewhorizons.modularui.api.math.MainAxisAlignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import org.jetbrains.annotations.NotNull;

public class Row
extends MultiChildWidget
implements IWidgetBuilder<Row> {
    private MainAxisAlignment maa = MainAxisAlignment.START;
    private CrossAxisAlignment caa = CrossAxisAlignment.START;
    private int maxWidth = -1;
    private int maxHeight = 0;
    private Integer space;
    protected boolean skipDisabledChild = false;

    @Override
    public void addWidgetInternal(Widget widget) {
        this.addChild(widget);
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        if (this.maa == MainAxisAlignment.START) {
            return IWidgetParent.getSizeOf(this.children);
        }
        return new Size(this.maxWidth, this.maxHeight);
    }

    @Override
    public void layoutChildren(int maxWidthC, int maxHeightC) {
        if (this.maxWidth < 0 && this.maa != MainAxisAlignment.START) {
            this.maxWidth = this.isAutoSized() ? maxWidthC - this.getPos().x : this.getSize().width;
        }
        this.maxHeight = 0;
        int totalWidth = 0;
        for (Widget widget : this.getChildren()) {
            if (this.skipDisabledChild && !widget.isEnabled()) continue;
            totalWidth += widget.getSize().width;
            this.maxHeight = Math.max(this.maxHeight, widget.getSize().height);
        }
        int lastX = 0;
        if (this.maa == MainAxisAlignment.CENTER) {
            lastX = (int)((float)this.maxWidth / 2.0f - (float)totalWidth / 2.0f);
        } else if (this.maa == MainAxisAlignment.END) {
            lastX = this.maxWidth - totalWidth;
        }
        for (Widget widget : this.getChildren()) {
            if (this.skipDisabledChild && !widget.isEnabled()) continue;
            int y = widget.getPos().y;
            if (this.caa == CrossAxisAlignment.CENTER) {
                y = (int)((float)this.maxHeight / 2.0f - (float)widget.getSize().height / 2.0f);
            } else if (this.caa == CrossAxisAlignment.END) {
                y = this.maxHeight - widget.getSize().height;
            }
            widget.setPosSilent(new Pos2d(lastX, y));
            lastX += widget.getSize().width;
            if (this.maa != MainAxisAlignment.SPACE_BETWEEN) continue;
            if (this.space != null) {
                lastX += this.space.intValue();
                continue;
            }
            lastX += (this.maxWidth - totalWidth) / (this.getChildren().size() - 1);
        }
    }

    public Row setAlignment(MainAxisAlignment maa) {
        return this.setAlignment(maa, this.caa);
    }

    public Row setAlignment(CrossAxisAlignment caa) {
        return this.setAlignment(this.maa, caa);
    }

    public Row setAlignment(MainAxisAlignment maa, CrossAxisAlignment caa) {
        this.maa = maa;
        this.caa = caa;
        return this;
    }

    public Row setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public Row setSpace(int space) {
        this.space = space;
        return this;
    }
}

