/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.element.MergedVertex;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class CurtainMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.1875);
        if (type == BoundingBoxType.SELECTION) {
            if (!topBlock) {
                aabb.field_72337_e += 1.0;
            } else {
                aabb.field_72338_b -= 1.0;
            }
        }
        if (tileEntity.isOpened()) {
            if (tileEntity.isReversed()) {
                aabb.field_72336_d = 0.1875;
            } else {
                aabb.field_72340_a = 0.8125;
            }
        }
        return aabb;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        float x = 0.8125f;
        String dir = "west";
        ForgeDirection fd = ForgeDirection.WEST;
        if (tileEntity.isReversed()) {
            x = -0.8125f;
            dir = "east";
            fd = ForgeDirection.EAST;
        }
        Translation translation = new Translation(x, 0.0f, 0.0f);
        translation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        translation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        Shape top = model.getShape("top");
        Shape bottom = model.getShape("bottom");
        top.enableMergedVertexes();
        bottom.enableMergedVertexes();
        List vertexes = top.getMergedVertexes(new String[]{"bottom", dir});
        vertexes.addAll(bottom.getMergedVertexes(fd));
        Animation[] anims = new Animation[vertexes.size()];
        int i = 0;
        for (MergedVertex mv : vertexes) {
            anims[i++] = new Animation((ITransformable)mv, (Transformation)translation);
        }
        return anims;
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

