/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.util.HashMap;
import net.malisis.core.MalisisCore;
import net.malisis.core.util.Point;
import net.malisis.core.util.Ray;
import net.malisis.core.util.RaytraceBlock;
import net.malisis.core.util.Vector;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class RaytraceWorld {
    private static int MAX_BLOCKS = 200;
    private World world;
    private Point src;
    private Point dest;
    private Ray ray;
    private Vector step;
    private ChunkPosition blockSrc;
    private ChunkPosition blockDest;
    private int currentX;
    private int currentY;
    private int currentZ;
    public MovingObjectPosition firstHit;
    public HashMap<ChunkPosition, MovingObjectPosition> blockPassed;
    public int options = 0;

    public RaytraceWorld(Ray ray, int options) {
        this.world = Minecraft.func_71410_x().field_71441_e;
        this.src = ray.origin;
        this.ray = ray;
        this.options = options;
        this.blockSrc = new ChunkPosition(this.src.toVec3());
        int stepX = 1;
        int stepY = 1;
        int stepZ = 1;
        if (ray.direction.x < 0.0) {
            stepX = -1;
        }
        if (ray.direction.y < 0.0) {
            stepY = -1;
        }
        if (ray.direction.z < 0.0) {
            stepZ = -1;
        }
        this.step = new Vector(stepX, stepY, stepZ);
        if (this.hasOption(Options.LOG_BLOCK_PASSED)) {
            this.blockPassed = new HashMap();
        }
    }

    public RaytraceWorld(Ray ray) {
        this(ray, 0);
    }

    public RaytraceWorld(Point src, Vector v, int options) {
        this(new Ray(src, v), options);
    }

    public RaytraceWorld(Point src, Vector v) {
        this(new Ray(src, v), 0);
    }

    public RaytraceWorld(Point src, Point dest, int options) {
        this(new Ray(src, new Vector(src, dest)), options);
        this.dest = dest;
        this.blockDest = new ChunkPosition(dest.toVec3());
    }

    public RaytraceWorld(Point src, Point dest) {
        this(new Ray(src, new Vector(src, dest)), 0);
        this.dest = dest;
        this.blockDest = new ChunkPosition(dest.toVec3());
    }

    public Point getSource() {
        return this.src;
    }

    public Point getDestination() {
        return this.dest;
    }

    public Vector direction() {
        return this.ray.direction;
    }

    public double distance() {
        return this.ray.direction.length();
    }

    public void setLength(double length) {
        this.dest = this.ray.getPointAt(length);
        this.blockDest = new ChunkPosition(this.dest.toVec3());
    }

    public boolean hasOption(int opt) {
        return (this.options & opt) != 0;
    }

    public MovingObjectPosition trace() {
        MovingObjectPosition mop = null;
        int count = 0;
        boolean ret = false;
        this.firstHit = null;
        this.currentX = this.blockSrc.field_151329_a;
        this.currentY = this.blockSrc.field_151327_b;
        this.currentZ = this.blockSrc.field_151328_c;
        while (!ret && count++ <= MAX_BLOCKS) {
            double tX = this.ray.intersectX(this.currentX + (this.ray.direction.x > 0.0 ? 1 : 0));
            double tY = this.ray.intersectY(this.currentY + (this.ray.direction.y > 0.0 ? 1 : 0));
            double tZ = this.ray.intersectZ(this.currentZ + (this.ray.direction.z > 0.0 ? 1 : 0));
            double min = this.getMin(tX, tY, tZ);
            if (count != 1 || !this.hasOption(Options.IGNORE_FIRST_BLOCK)) {
                mop = this.rayTraceBlock(this.currentX, this.currentY, this.currentZ, this.ray.getPointAt(min));
            }
            if (this.firstHit == null) {
                this.firstHit = mop;
            }
            if (this.hasOption(Options.LOG_BLOCK_PASSED)) {
                this.blockPassed.put(new ChunkPosition(this.currentX, this.currentY, this.currentZ), mop);
            }
            if (this.dest != null && this.currentX == this.blockDest.field_151329_a && this.currentY == this.blockDest.field_151327_b && this.currentZ == this.blockDest.field_151328_c) {
                ret = true;
            }
            if (!ret) {
                if (min == tX) {
                    this.currentX = (int)((double)this.currentX + this.step.x);
                }
                if (min == tY) {
                    this.currentY = (int)((double)this.currentY + this.step.y);
                }
                if (min == tZ) {
                    this.currentZ = (int)((double)this.currentZ + this.step.z);
                }
            }
            if (this.dest == null || !this.dest.equals(this.ray.getPointAt(min))) continue;
            ret = true;
        }
        if (this.firstHit == null && this.dest != null) {
            this.firstHit = new MovingObjectPosition(this.currentX, this.currentY, this.currentZ, -1, this.dest.toVec3(), false);
        }
        ChunkCollision.get().setRayTraceInfos(this.src, this.dest);
        this.firstHit = ChunkCollision.get().getRayTraceResult(this.world, this.firstHit);
        if (!ret) {
            MalisisCore.message("Trace fail : " + MAX_BLOCKS + " blocks passed (" + this.currentX + "," + this.currentY + "," + this.currentZ + ")");
        }
        return this.firstHit;
    }

    public double getMin(double x, double y, double z) {
        double ret = Double.NaN;
        if (!Double.isNaN(x)) {
            ret = x;
        }
        if (!Double.isNaN(y)) {
            ret = !Double.isNaN(ret) ? Math.min(ret, y) : y;
        }
        if (!Double.isNaN(z)) {
            ret = !Double.isNaN(ret) ? Math.min(ret, z) : z;
        }
        return ret;
    }

    public MovingObjectPosition rayTraceBlock(int x, int y, int z, Point exit) {
        Block block = this.world.func_147439_a(x, y, z);
        int metadata = this.world.func_72805_g(x, y, z);
        if (this.hasOption(Options.CHECK_COLLISION) && block.func_149668_a(this.world, x, y, z) == null) {
            return null;
        }
        if (!block.func_149678_a(metadata, this.hasOption(Options.HIT_LIQUIDS))) {
            return null;
        }
        return new RaytraceBlock(this.world, this.src, exit, x, y, z).trace();
    }

    public static class Options {
        public static int HIT_LIQUIDS = 1;
        public static int PASS_THROUGH = 2;
        public static int IGNORE_FIRST_BLOCK = 4;
        public static int LOG_BLOCK_PASSED = 8;
        public static int CHECK_COLLISION = 32;
    }
}

