/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import java.awt.Desktop;
import java.net.URI;
import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import org.apache.commons.lang3.StringUtils;

public class Link
implements GuiYesNoCallback {
    private int index = 0;
    private int textIndex = 0;
    private String url;
    private String text;
    private boolean isValid;

    public Link(int index, String str) {
        this.index = index;
        int i = str.indexOf(124);
        if (i == -1) {
            this.url = str;
            this.text = str;
            this.textIndex = 1;
        } else {
            this.url = str.substring(0, i);
            this.text = str.substring(i + 1, str.length());
            this.textIndex = i + 1;
        }
        this.checkUrl();
    }

    public Link(int index, String url, String text) {
        this.index = index;
        this.url = url;
        this.text = text;
    }

    private void checkUrl() {
        this.isValid = true;
    }

    public float getWidth(MalisisFont font, FontRenderOptions fro) {
        return font.getStringWidth(StringUtils.isEmpty((CharSequence)this.text) ? this.url : this.text, fro);
    }

    public int indexAdvance() {
        return this.text != null ? this.url.length() + 2 : 1;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isUrl(int index) {
        return (index += this.index) >= 0 && index <= this.url.length();
    }

    public boolean isText(int index) {
        return (index += this.index) >= this.textIndex && index <= this.text.length();
    }

    public void click() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, this.url, 0, false));
    }

    public void func_73878_a(boolean result, int id) {
        if (result) {
            MalisisCore.message("Opening " + this.url);
            try {
                Desktop.getDesktop().browse(new URI(this.url));
            }
            catch (Throwable throwable) {
                MalisisCore.log.error("Couldn't open link", throwable);
            }
        } else {
            MalisisCore.message("Cancel");
        }
    }

    public String toString() {
        return "[" + this.url + (this.text != null ? "|" + this.text : "") + "]";
    }

    public static Link getLink(String str, int index) {
        Link link = null;
        int i = index;
        while (i > 0) {
            if ((link = FontRenderOptions.getLink(str, i--)) == null || index >= link.index + link.toString().length()) continue;
            return link;
        }
        return null;
    }
}

