/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat.baubles;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import magicbees.bees.BeeManager;
import magicbees.client.gui.UIScreens;
import magicbees.main.MagicBees;
import magicbees.main.utils.TabMagicBees;
import magicbees.main.utils.compat.baubles.InventoryBeeRing;
import magicbees.main.utils.compat.baubles.RingHousing;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemBeeRing
extends Item
implements IBauble {
    private static final Map<UUID, IEffectData[][]> PLAYER_EFFECTS = new HashMap<UUID, IEffectData[][]>();

    public ItemBeeRing() {
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77656_e(0);
        this.func_111206_d("magicbees:beeRing");
        this.func_77637_a(TabMagicBees.tabMagicBees);
        this.func_77655_b("beeRing");
        GameRegistry.registerItem((Item)this, (String)"beeRing");
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
                for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                    ItemStack stackInSlot;
                    if (!baubles.func_94041_b(i, itemStack) || (stackInSlot = baubles.func_70301_a(i)) != null) continue;
                    baubles.func_70299_a(i, itemStack.func_77946_l());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                    break;
                }
            } else {
                player.openGui((Object)MagicBees.object, UIScreens.EFFECT_RING.ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        }
        return itemStack;
    }

    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.RING;
    }

    public void onWornTick(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLivingBase;
        InventoryBeeRing inventoryBeeRing = new InventoryBeeRing(itemStack, player);
        if (inventoryBeeRing.hasQueen()) {
            this.tickQueen(player, inventoryBeeRing);
        } else if (inventoryBeeRing.hasDrone()) {
            this.createQueenFromDrone(inventoryBeeRing);
        }
    }

    private void createQueenFromDrone(InventoryBeeRing inventoryBeeRing) {
        ItemStack droneStack = inventoryBeeRing.getDrone();
        if (BeeManager.beeRoot.isDrone(droneStack)) {
            IBee bee = BeeManager.beeRoot.getMember(droneStack);
            if (droneStack.field_77994_a == 1) {
                inventoryBeeRing.setDrone(null);
            } else {
                --droneStack.field_77994_a;
                inventoryBeeRing.setDrone(droneStack);
            }
            ItemStack queenStack = droneStack.func_77946_l();
            queenStack.field_77994_a = 1;
            inventoryBeeRing.setQueen(queenStack);
            int beeHealth = bee.getHealth();
            int maxBeeHealth = bee.getMaxHealth();
            inventoryBeeRing.setCurrentBeeHealth(beeHealth * 100 / maxBeeHealth);
            inventoryBeeRing.setCurrentBeeColour(bee.getGenome().getPrimary().getIconColour(0));
        }
    }

    private void tickQueen(EntityPlayer player, InventoryBeeRing inventoryBeeRing) {
        ItemStack queenStack = inventoryBeeRing.getQueen();
        IBee queen = BeeManager.beeRoot.getMember(queenStack);
        inventoryBeeRing.setCurrentBeeHealth(queen.getHealth() * 100 / queen.getMaxHealth());
        inventoryBeeRing.setCurrentBeeColour(queen.getGenome().getPrimary().getIconColour(0));
        IEffectData[][] effects = ItemBeeRing.getPlayerEffects(player);
        int index = inventoryBeeRing.getRingSlotIndex();
        RingHousing housingLogic = new RingHousing(player, inventoryBeeRing);
        effects[index] = queen.doEffect(effects[index], (IBeeHousing)housingLogic);
        if (player.field_70170_p.field_72995_K && player.field_70170_p.func_72820_D() % 5L == 0L) {
            effects[index] = queen.doFX(effects[index], (IBeeHousing)housingLogic);
        }
        ItemBeeRing.setPlayerEffects(player, effects);
        int throttle = inventoryBeeRing.getThrottle();
        if (throttle > 550) {
            inventoryBeeRing.setThrottle(0);
            queen.age(player.field_70170_p, 0.26f);
            if (queen.getHealth() == 0) {
                inventoryBeeRing.setQueen(null);
                inventoryBeeRing.setCurrentBeeHealth(0);
                inventoryBeeRing.setCurrentBeeColour(0xFFFFFF);
            } else {
                queen.writeToNBT(queenStack.func_77978_p());
                inventoryBeeRing.setQueen(queenStack);
            }
        } else {
            inventoryBeeRing.setThrottle(throttle + 1);
        }
    }

    private static IEffectData[][] getPlayerEffects(EntityPlayer player) {
        IEffectData[][] iEffectDataArray;
        UUID id = player.func_110124_au();
        if (PLAYER_EFFECTS.containsKey(id)) {
            iEffectDataArray = PLAYER_EFFECTS.get(id);
        } else {
            IEffectData[][] iEffectDataArrayArray = new IEffectData[2][];
            iEffectDataArrayArray[0] = new IEffectData[2];
            iEffectDataArray = iEffectDataArrayArray;
            iEffectDataArrayArray[1] = new IEffectData[2];
        }
        return iEffectDataArray;
    }

    private static void setPlayerEffects(EntityPlayer player, IEffectData[][] effects) {
        PLAYER_EFFECTS.put(player.func_110124_au(), effects);
    }

    public void onEquipped(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        if (entityLivingBase instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            InventoryBeeRing inventoryBeeRing = new InventoryBeeRing(itemStack, player);
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                if (baubles.func_70301_a(i) != itemStack) continue;
                inventoryBeeRing.setRingSlotIndex(i == 1 ? 0 : 1);
                break;
            }
        }
    }

    public void onUnequipped(ItemStack itemStack, EntityLivingBase entityLivingBase) {
    }

    public boolean canEquip(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }

    public boolean canUnequip(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }
}

