/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockUtil {
    public static int getSurroundCount(World world, int x, int y, int z, Block blockType) {
        int surroundCount = 0;
        if (BlockUtil.canBlockReplaceAt(world, x + 1, y, z, blockType)) {
            ++surroundCount;
        }
        if (BlockUtil.canBlockReplaceAt(world, x - 1, y, z, blockType)) {
            ++surroundCount;
        }
        if (BlockUtil.canBlockReplaceAt(world, x, y + 1, z, blockType)) {
            ++surroundCount;
        }
        if (BlockUtil.canBlockReplaceAt(world, x, y - 1, z, blockType)) {
            ++surroundCount;
        }
        if (BlockUtil.canBlockReplaceAt(world, x, y, z + 1, blockType)) {
            ++surroundCount;
        }
        if (BlockUtil.canBlockReplaceAt(world, x, y, z - 1, blockType)) {
            ++surroundCount;
        }
        return surroundCount;
    }

    public static boolean canBlockReplaceAt(World world, int x, int y, int z, Block target) {
        if (!world.func_72899_e(x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        return block.isReplaceableOreGen(world, x, y, z, target);
    }

    public static List<Chunk> getChunksInSearchRange(World world, int xCoord, int zCoord, int searchRadius) {
        ArrayList<Chunk> searchChunks = new ArrayList<Chunk>();
        int chunkRange = (int)Math.ceil((double)searchRadius / 16.0);
        int minChunkX = xCoord / 16 - chunkRange;
        int maxChunkX = xCoord / 16 + chunkRange;
        int minChunkZ = zCoord / 16 - chunkRange;
        int maxChunkZ = zCoord / 16 + chunkRange;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                if (chunk == null) continue;
                searchChunks.add(chunk);
            }
        }
        return searchChunks;
    }
}

