/*
 * Decompiled with CFR 0.152.
 */
package magicbees.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.List;
import magicbees.block.MaterialHive;
import magicbees.block.types.HiveType;
import magicbees.main.Config;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHive
extends Block {
    public BlockHive() {
        super((Material)new MaterialHive());
        this.func_149715_a(0.8f);
        this.func_149711_c(1.0f);
        this.func_149647_a(Tabs.tabApiculture);
        this.func_149663_c("hive");
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return false;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 0 || meta > HiveType.values().length) {
            meta = 0;
        }
        return HiveType.getHiveFromMeta(meta).getLightValue();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List itemsList) {
        for (HiveType type : HiveType.values()) {
            if (!type.show && !Config.forestryDebugEnabled) continue;
            itemsList.add(new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return HiveType.getHiveFromMeta(metadata).getDrops(world, x, y, z, fortune);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        HiveType.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta > HiveType.values().length) {
            meta = 0;
        }
        return HiveType.getHiveFromMeta(meta).getIconForSide(side);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return null;
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, this.func_149643_k(world, x, y, z) & 7);
    }
}

