/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.minigame;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.timeconqueror.lootgames.api.LootGamesAPI;
import ru.timeconqueror.lootgames.api.block.tile.BoardGameMasterTile;
import ru.timeconqueror.lootgames.api.block.tile.GameMasterTile;
import ru.timeconqueror.lootgames.api.minigame.LootGame;
import ru.timeconqueror.lootgames.api.util.Pos2i;
import ru.timeconqueror.lootgames.utils.MouseClickType;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.timecore.api.util.EnvironmentUtils;

public abstract class BoardLootGame<G extends BoardLootGame<G>>
extends LootGame<BoardStage, G> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean disableMasterCheckWarning;
    @Nullable
    private BoardStage stage;

    @Override
    public void setMasterTileEntity(GameMasterTile<G> masterTileEntity) {
        super.setMasterTileEntity(masterTileEntity);
        if (EnvironmentUtils.isInDev() && !disableMasterCheckWarning && !(masterTileEntity instanceof BoardGameMasterTile)) {
            LOGGER.warn("You probably forgot that {} needs to extend {} to handle {} properly.", new Object[]{((Object)masterTileEntity).getClass().getSimpleName(), BoardGameMasterTile.class.getSimpleName(), BoardLootGame.class.getSimpleName()});
        }
    }

    @Override
    public BlockPos getGameCenter() {
        int size = this.getCurrentBoardSize();
        return this.getBoardOrigin().offset(size / 2, 0, size / 2);
    }

    @Override
    protected BlockPos getRoomFloorPos() {
        return this.getMasterPos();
    }

    public abstract int getCurrentBoardSize();

    public abstract int getAllocatedBoardSize();

    @Override
    public void onDestroy() {
        LootGamesAPI.getFieldManager().clearBoard((WorldServer)this.getWorld(), this.getMasterPos(), this.getAllocatedBoardSize(), this.getAllocatedBoardSize());
    }

    public Pos2i convertToGamePos(BlockPos subordinatePos) {
        BlockPos result = subordinatePos.subtract(this.getBoardOrigin());
        return new Pos2i(result.getX(), result.getZ());
    }

    public BlockPos convertToBlockPos(Pos2i pos) {
        return this.getBoardOrigin().offset(pos.getX(), 0, pos.getY());
    }

    public BlockPos getBoardOrigin() {
        int offset = this.getAllocatedBoardSize() - this.getCurrentBoardSize();
        return this.getMasterPos().mutable().move(1, 0, 1).move(offset / 2, 0, offset / 2).immutable();
    }

    public void onClick(EntityPlayer player, Pos2i pos, MouseClickType type) {
        if (this.getStage() != null) {
            ((BoardStage)this.getStage()).onClick(player, pos, type);
        }
    }

    public static abstract class BoardStage
    extends LootGame.Stage {
        protected void onClick(EntityPlayer player, Pos2i pos, MouseClickType type) {
        }
    }
}

