/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.cc;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import java.lang.reflect.Field;
import logisticspipes.LogisticsPipes;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.cc.LPPeripheralProvider;
import logisticspipes.proxy.cc.wrapper.CCCommandWrapper;
import logisticspipes.proxy.computers.wrapper.CCObjectWrapper;
import logisticspipes.proxy.interfaces.ICCProxy;
import logisticspipes.proxy.interfaces.ICraftingParts;
import logisticspipes.recipes.CraftingDependency;
import logisticspipes.recipes.RecipeManager;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class CCProxy
implements ICCProxy {
    private final Field target;

    public CCProxy() throws NoSuchFieldException, SecurityException {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new LPPeripheralProvider());
        this.target = Thread.class.getDeclaredField("target");
        this.target.setAccessible(true);
    }

    @Override
    public boolean isTurtle(TileEntity tile) {
        return tile instanceof TileTurtle;
    }

    @Override
    public boolean isComputer(TileEntity tile) {
        return tile instanceof TileComputer;
    }

    @Override
    public boolean isCC() {
        return true;
    }

    private Runnable getTaget(Thread thread) {
        try {
            return (Runnable)this.target.get(thread);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isLuaThread(Thread thread) {
        Runnable tar = this.getTaget(thread);
        if (tar == null) {
            return false;
        }
        return tar.getClass().getName().contains("org.luaj.vm2.LuaThread");
    }

    @Override
    public void queueEvent(String event, Object[] arguments, LogisticsTileGenericPipe tile) {
        for (Object computerO : tile.connections.keySet()) {
            IComputerAccess computer = (IComputerAccess)computerO;
            computer.queueEvent(event, arguments);
        }
    }

    @Override
    public void setTurtleConnect(boolean flag, LogisticsTileGenericPipe tile) {
        tile.turtleConnect[tile.connections.get((Object)tile.currentPC).ordinal()] = flag;
        tile.scheduleNeighborChange();
    }

    @Override
    public boolean getTurtleConnect(LogisticsTileGenericPipe tile) {
        return tile.turtleConnect[tile.connections.get(tile.currentPC).ordinal()];
    }

    @Override
    public int getLastCCID(LogisticsTileGenericPipe tile) {
        if (tile.currentPC == null) {
            return -1;
        }
        return ((IComputerAccess)tile.currentPC).getID();
    }

    @Override
    public void handleMesssage(int computerId, Object message, LogisticsTileGenericPipe tile, int sourceId) {
        for (Object computerO : tile.connections.keySet()) {
            IComputerAccess computer = (IComputerAccess)computerO;
            if (computer.getID() != computerId) continue;
            computer.queueEvent("LP_MESSAGE", new Object[]{sourceId, message});
        }
    }

    @Override
    public void addCraftingRecipes(ICraftingParts parts) {
        RecipeManager.LocalCraftingManager craftingManager = RecipeManager.craftingManager;
        craftingManager.addRecipe(new ItemStack((Item)LogisticsPipes.UpgradeItem, 1, 40), CraftingDependency.Upgrades, false, "rTr", "WCM", "rKr", Character.valueOf('C'), parts.getChipTear3(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('W'), new ItemStack((Block)ComputerCraft.Blocks.peripheral, 1, 1), Character.valueOf('M'), new ItemStack((Block)ComputerCraft.Blocks.cable, 1, 1), Character.valueOf('K'), new ItemStack((Block)ComputerCraft.Blocks.cable, 1, 0));
        craftingManager.addRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 15), CraftingDependency.Upgrades, false, "rTr", "WCM", "rKr", Character.valueOf('C'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 1), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('W'), new ItemStack((Block)ComputerCraft.Blocks.peripheral, 1, 1), Character.valueOf('M'), new ItemStack((Block)ComputerCraft.Blocks.cable, 1, 1), Character.valueOf('K'), new ItemStack((Block)ComputerCraft.Blocks.cable, 1, 0));
        craftingManager.addRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 14), CraftingDependency.Upgrades, false, "rTr", "WCM", "rKr", Character.valueOf('C'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 5), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('W'), new ItemStack((Block)ComputerCraft.Blocks.peripheral, 1, 1), Character.valueOf('M'), new ItemStack((Block)ComputerCraft.Blocks.cable, 1, 1), Character.valueOf('K'), new ItemStack((Block)ComputerCraft.Blocks.cable, 1, 0));
    }

    @Override
    public Object getAnswer(Object object) {
        return CCObjectWrapper.getWrappedObject(object, CCCommandWrapper.WRAPPER);
    }
}

