/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import logisticspipes.interfaces.ISpecialInsertion;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.network.packets.pipe.SlotFinderActivatePacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class SlotFinderOpenGuiPacket
extends ModuleCoordinatesPacket {
    private int slot;

    public SlotFinderOpenGuiPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        int i;
        int savedEquipped = player.field_71071_by.field_70461_c;
        boolean foundSlot = false;
        for (i = 0; i < 9; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            foundSlot = true;
            player.field_71071_by.field_70461_c = i;
            break;
        }
        if (!foundSlot) {
            for (i = 0; i < 9; ++i) {
                ItemStack is = player.field_71071_by.func_70301_a(i);
                if (!(is.func_77973_b() instanceof ItemBlock)) continue;
                foundSlot = true;
                player.field_71071_by.field_70461_c = i;
                break;
            }
        }
        if (!foundSlot) {
            player.field_71071_by.field_70461_c = (player.field_71071_by.field_70461_c + 1) % 9;
        }
        WorldUtil worldUtil = new WorldUtil(player.field_70170_p, this.getPosX(), this.getPosY(), this.getPosZ());
        boolean found = false;
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            if (tile instanceof IInventory && !(SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil((IInventory)tile) instanceof ISpecialInsertion)) continue;
            for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                if (!provider.canOpenGui(tile.tile)) continue;
                found = true;
                break;
            }
            if (!found) {
                found = tile.tile instanceof IInventory;
            }
            if (!found) continue;
            Block block = player.field_70170_p.func_147439_a(tile.tile.field_145851_c, tile.tile.field_145848_d, tile.tile.field_145849_e);
            if (SimpleServiceLocator.enderStorageProxy.isEnderChestBlock(block)) {
                SimpleServiceLocator.enderStorageProxy.openEnderChest(player.field_70170_p, tile.tile.field_145851_c, tile.tile.field_145848_d, tile.tile.field_145849_e, player);
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SlotFinderActivatePacket.class).setTagetPosX(tile.tile.field_145851_c).setTagetPosY(tile.tile.field_145848_d).setTagetPosZ(tile.tile.field_145849_e).setSlot(this.getSlot()).setPacketPos(this), player);
            }
            if (block == null || !block.func_149727_a(player.field_70170_p, tile.tile.field_145851_c, tile.tile.field_145848_d, tile.tile.field_145849_e, player, 0, 0.0f, 0.0f, 0.0f)) continue;
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SlotFinderActivatePacket.class).setTagetPosX(tile.tile.field_145851_c).setTagetPosY(tile.tile.field_145848_d).setTagetPosZ(tile.tile.field_145849_e).setSlot(this.getSlot()).setPacketPos(this), player);
            break;
        }
        player.field_71071_by.field_70461_c = savedEquipped;
    }

    @Override
    public ModernPacket template() {
        return new SlotFinderOpenGuiPacket(this.getId());
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.slot);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.slot = data.readInt();
    }

    public int getSlot() {
        return this.slot;
    }

    public SlotFinderOpenGuiPacket setSlot(int slot) {
        this.slot = slot;
        return this;
    }
}

