/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic.gui;

import java.util.ArrayList;
import logisticspipes.logic.LogicController;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SimpleGraphics;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.ChatColor;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LogicLayoutGui
extends LogisticsBaseGuiScreen {
    private static final ResourceLocation achievementTextures = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    private final LogicController controller;
    private final RenderItem renderitem = new RenderItem();
    private int isMouseButtonDown;
    private int mouseX;
    private int mouseY;
    private double guiMapX;
    private double guiMapY;
    private ZOOM_LEVEL zoom = ZOOM_LEVEL.NORMAL;
    private Object[] tooltip = null;

    public LogicLayoutGui(LogicController controller, EntityPlayer player) {
        super(256, 292, 0, 0);
        this.controller = controller;
        this.guiMapY = -200.0;
        Mouse.getDWheel();
        DummyContainer dummy = new DummyContainer((IInventory)player.field_71071_by, null);
        dummy.addNormalSlotsForPlayerInventory(50, 205);
        this.field_147002_h = dummy;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
    }

    protected void func_146284_a(GuiButton button) {
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        if (Mouse.isButtonDown((int)0)) {
            int k = (this.field_146294_l - this.field_146999_f) / 2;
            int l = (this.field_146295_m - this.field_147000_g) / 2;
            int i1 = k + 8;
            int j1 = l + 17;
            if ((this.isMouseButtonDown == 0 || this.isMouseButtonDown == 1) && par1 >= i1 && par1 < i1 + 224 && par2 >= j1 && par2 < j1 + 155) {
                if (this.isMouseButtonDown == 0) {
                    this.isMouseButtonDown = 1;
                } else {
                    this.guiMapX -= (double)(par1 - this.mouseX) * 1.0 / (double)this.zoom.zoom;
                    this.guiMapY -= (double)(par2 - this.mouseY) * 1.0 / (double)this.zoom.zoom;
                }
                this.mouseX = par1;
                this.mouseY = par2;
            }
        } else {
            this.isMouseButtonDown = 0;
        }
        int dWheel = Mouse.getDWheel();
        if (dWheel < 0) {
            this.zoom = this.zoom.next();
        } else if (dWheel > 0) {
            this.zoom = this.zoom.prev();
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        if (this.tooltip != null) {
            GuiGraphics.displayItemToolTip(this.tooltip, this.field_73735_i, this.field_147003_i, this.field_147009_r, true);
        }
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        super.func_146976_a(f, i, j);
        this.drawTransparentBack();
        this.drawMap(i, j);
        GuiGraphics.drawGuiBackGround(this.getMC(), this.field_147003_i, this.field_147009_r + 180, this.right, this.bottom, this.field_73735_i, true, false, true, true, true);
        GuiGraphics.drawPlayerInventoryBackground(this.getMC(), this.field_147003_i + 50, this.field_147009_r + 205);
    }

    private void drawTransparentBack() {
        GL11.glEnable((int)2929);
        SimpleGraphics.drawGradientRect(0, 0, this.field_146294_l, this.field_146295_m, Color.BLANK, Color.BLANK, 0.0);
    }

    private void drawMap(int par1, int par2) {
        this.tooltip = null;
        int mapX = MathHelper.func_76128_c((double)this.guiMapX);
        int mapY = MathHelper.func_76128_c((double)(this.guiMapY - (double)this.zoom.moveY));
        int leftSide = (this.field_146294_l - this.field_146999_f) / 2;
        int topSide = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(achievementTextures);
        this.func_73729_b(leftSide, topSide, 0, 0, 256, 202);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
        this.field_147009_r = (int)((float)this.field_147009_r * (1.0f / this.zoom.zoom));
        this.field_147003_i = (int)((float)this.field_147003_i * (1.0f / this.zoom.zoom));
        this.field_146999_f = (int)((float)this.field_146999_f * (1.0f / this.zoom.zoom));
        this.field_147000_g = (int)((float)this.field_147000_g * (1.0f / this.zoom.zoom));
        leftSide = (int)((float)leftSide * (1.0f / this.zoom.zoom));
        topSide = (int)((float)topSide * (1.0f / this.zoom.zoom));
        par1 = (int)((float)par1 * (1.0f / this.zoom.zoom));
        par2 = (int)((float)par2 * (1.0f / this.zoom.zoom));
        int innerLeftSide = leftSide + 16;
        int innerTopSide = topSide + 17;
        this.field_73735_i = 0.0f;
        GL11.glDepthFunc((int)518);
        GL11.glPushMatrix();
        GL11.glScalef((float)this.zoom.zoom, (float)this.zoom.zoom, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        int moveBackgroundX = mapX % 16 + (mapX < 0 ? 16 : 0);
        int moveBackgroundY = mapY % 16 + (mapY < 0 ? 16 : 0);
        GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
        int yVar = 0;
        while (yVar * 16 - moveBackgroundY < this.zoom.bottomRenderBorder) {
            int xVar = 0;
            while (xVar * 16 - moveBackgroundX < this.zoom.rightRenderBorder) {
                IIcon icon = Blocks.field_150348_b.func_149691_a(0, 0);
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                this.func_94065_a(innerLeftSide + xVar * 16 - moveBackgroundX, innerTopSide + yVar * 16 - moveBackgroundY, icon, 16, 16);
                ++xVar;
            }
            ++yVar;
        }
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(achievementTextures);
        GL11.glPopMatrix();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        this.field_147009_r = (int)((float)this.field_147009_r * this.zoom.zoom);
        this.field_147003_i = (int)((float)this.field_147003_i * this.zoom.zoom);
        this.field_146999_f = (int)((float)this.field_146999_f * this.zoom.zoom);
        this.field_147000_g = (int)((float)this.field_147000_g * this.zoom.zoom);
        leftSide = (int)((float)leftSide * this.zoom.zoom);
        topSide = (int)((float)topSide * this.zoom.zoom);
        GL11.glScalef((float)(1.0f / this.zoom.zoom), (float)(1.0f / this.zoom.zoom), (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(achievementTextures);
        this.func_73729_b(leftSide, topSide, 0, 0, 256, 202);
        GL11.glPopMatrix();
        this.field_73735_i = 0.0f;
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        RenderHelper.func_74518_a();
    }

    private void renderLinkedOrderListItems(LinkedLogisticsOrderList list, int xPos, int yPos, int par1, int par2) {
        int size = list.size();
        int startLeft = -(size - 1) * 15 + xPos;
        yPos += 13;
        for (IOrderInfoProvider iOrderInfoProvider : list) {
            if (iOrderInfoProvider.isInProgress()) {
                GL11.glColor4f((float)0.1f, (float)0.9f, (float)0.1f, (float)1.0f);
            } else {
                GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
            GL11.glEnable((int)2896);
            this.field_146297_k.func_110434_K().func_110577_a(achievementTextures);
            this.func_73729_b(startLeft - 5, yPos - 5, 0, 202, 26, 26);
            GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            this.renderItemAt(iOrderInfoProvider.getAsDisplayItem(), startLeft, yPos);
            if (iOrderInfoProvider.isInProgress() && iOrderInfoProvider.getMachineProgress() != 0) {
                Gui.func_73734_a((int)(startLeft - 4), (int)(yPos + 20), (int)(startLeft + 20), (int)(yPos + 24), (int)-16777216);
                Gui.func_73734_a((int)(startLeft - 3), (int)(yPos + 21), (int)(startLeft + 19), (int)(yPos + 23), (int)-1);
                Gui.func_73734_a((int)(startLeft - 3), (int)(yPos + 21), (int)(startLeft - 3 + 22 * iOrderInfoProvider.getMachineProgress() / 100), (int)(yPos + 23), (int)-65536);
            }
            if (startLeft - 10 < par1 && par1 < startLeft + 20 && yPos - 6 < par2 && par2 < yPos + 20 && this.field_147003_i < par1 && par1 < this.field_147003_i + this.field_146999_f - 16 && this.field_147009_r < par2 && par2 < this.field_147009_r + this.field_147000_g - 16) {
                ArrayList<String> tooltipList = new ArrayList<String>();
                tooltipList.add((Object)((Object)ChatColor.BLUE) + "Request Type: " + (Object)((Object)ChatColor.YELLOW) + iOrderInfoProvider.getType().name());
                tooltipList.add((Object)((Object)ChatColor.BLUE) + "Send to Router ID: " + (Object)((Object)ChatColor.YELLOW) + iOrderInfoProvider.getRouterId());
                this.tooltip = new Object[]{(int)((float)par1 * this.zoom.zoom - 10.0f), (int)((float)par2 * this.zoom.zoom), iOrderInfoProvider.getAsDisplayItem().makeNormalStack(), true, tooltipList};
            }
            startLeft += 30;
        }
        startLeft = xPos + 20 - list.getSubTreeRootSize() * 20;
        if (!list.getSubOrders().isEmpty()) {
            for (int i = 0; i < list.getSubOrders().size(); ++i) {
                this.renderLinkedOrderListItems(list.getSubOrders().get(i), (startLeft += list.getSubOrders().get(i).getTreeRootSize() * 20) - 20, yPos + 48, par1, par2);
                startLeft += list.getSubOrders().get(i).getTreeRootSize() * 20;
            }
        }
    }

    private void renderLinkedOrderListLines(LinkedLogisticsOrderList list, int xPos, int yPos) {
        int i;
        int size = list.size();
        if (list.isEmpty()) {
            size = 1;
        }
        int startLeft = -(size - 1) * 15 + xPos;
        yPos += 13;
        int left = startLeft;
        for (i = 0; i < list.size(); ++i) {
            SimpleGraphics.drawVerticalLine(startLeft + 8, yPos - 13, yPos - 3, Color.GREEN, this.zoom.line);
            if (!list.getSubOrders().isEmpty()) {
                SimpleGraphics.drawVerticalLine(startLeft + 8, yPos + 18, yPos + 28, Color.GREEN, this.zoom.line);
            }
            startLeft += 30;
        }
        if (!list.isEmpty()) {
            SimpleGraphics.drawHorizontalLine(left + 8, startLeft - 22, yPos - 13, Color.GREEN, this.zoom.line);
        }
        if (!list.getSubOrders().isEmpty()) {
            if (!list.isEmpty()) {
                SimpleGraphics.drawHorizontalLine(left + 8, startLeft - 22, yPos + 28, Color.GREEN, this.zoom.line);
                startLeft -= 30;
            }
            SimpleGraphics.drawVerticalLine(left + (startLeft - left) / 2 + 8, yPos + 28, yPos + 38, Color.GREEN, this.zoom.line);
            left = startLeft = xPos + 20 - list.getSubTreeRootSize() * 20;
            for (i = 0; i < list.getSubOrders().size(); ++i) {
                SimpleGraphics.drawVerticalLine((startLeft += list.getSubOrders().get(i).getTreeRootSize() * 20) - 12, yPos + 38, yPos + 48, Color.GREEN, this.zoom.line);
                this.drawPointFor(list, xPos, yPos, i, startLeft);
                this.renderLinkedOrderListLines(list.getSubOrders().get(i), startLeft - 20, yPos + 48);
                startLeft += list.getSubOrders().get(i).getTreeRootSize() * 20;
            }
            if (!list.getSubOrders().isEmpty()) {
                left += list.getSubOrders().get(0).getTreeRootSize() * 20;
                startLeft -= list.getSubOrders().get(list.getSubOrders().size() - 1).getTreeRootSize() * 20;
            }
            SimpleGraphics.drawHorizontalLine(left - 12, startLeft - 12, yPos + 38, Color.GREEN, this.zoom.line);
        }
    }

    private void drawPointFor(LinkedLogisticsOrderList list, int xPos, int yPos, int i, int startLeft) {
        float totalLine = 22 + Math.abs(startLeft - (xPos + 20)) + 10 + 1 + 10;
        for (Float point : list.getSubOrders().get(i).getProgresses()) {
            int j;
            int newStartLeft;
            int newSize;
            int pos = (int)(totalLine * (1.0f - point.floatValue()));
            if (pos < 13) {
                newSize = list.getSubOrders().get(i).size();
                newStartLeft = -(newSize - 1) * 15 + startLeft - 20;
                for (j = 0; j < newSize; ++j) {
                    this.drawProgressPoint(newStartLeft + 8, yPos + 48 + 12 - pos, -16711936);
                    newStartLeft += 30;
                }
                continue;
            }
            if (pos < 22) {
                this.drawProgressPoint(startLeft - 20 + 8, yPos + 38 + 12 - (pos -= 10), -16711936);
                continue;
            }
            if (pos < Math.abs(startLeft - (xPos + 20)) + 10 + 1 + 10 + 1) {
                pos -= 22;
                if (startLeft < xPos + 20) {
                    pos *= -1;
                }
                this.drawProgressPoint(startLeft - 12 - pos, yPos + 38, -16711936);
                continue;
            }
            if (pos < Math.abs(startLeft - (xPos + 20)) + 10 + 1 + 10 + 1 + 10 + 1) {
                this.drawProgressPoint(xPos + 8, yPos + 27 - (pos -= 22 + Math.abs(startLeft - (xPos + 20)) + 10 + 1), -16711936);
                continue;
            }
            if (pos >= Math.abs(startLeft - (xPos + 20)) + 10 + 1 + 10 + 1 + 10 + 1 + 10 + 1) continue;
            pos -= 22 + Math.abs(startLeft - (xPos + 20)) + 10 + 1 + 10 + 1;
            newSize = list.size();
            newStartLeft = -(newSize - 1) * 15 + xPos;
            for (j = 0; j < newSize; ++j) {
                this.drawProgressPoint(newStartLeft + 8, yPos + 16 - pos, -16711936);
                newStartLeft += 30;
            }
        }
    }

    private void renderItemAt(ItemIdentifierStack item, int x, int y) {
        this.renderitem.func_82406_b(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), item.makeNormalStack(), x, y);
        if (this.field_147003_i < x && x < this.field_147003_i + this.field_146999_f - 16 && this.field_147009_r < y && y < this.field_147009_r + this.field_147000_g - 16) {
            this.renderitem.func_94148_a(this.field_146297_k.field_71466_p, this.field_146297_k.field_71446_o, item.makeNormalStack(), x, y, "");
            String s = StringUtils.getFormatedStackSize(item.getStackSize(), false);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            this.renderitem.field_77023_b = 0.0f;
            this.field_146297_k.field_71466_p.func_78261_a(s, x + 17 - this.field_146297_k.field_71466_p.func_78256_a(s), y + 9, 0xFFFFFF);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)2896);
        }
    }

    protected void drawProgressPoint(int x, int y, int color) {
        int line = this.zoom.line + 1;
        Gui.func_73734_a((int)(x - line + 1), (int)(y - line + 1), (int)(x + line), (int)(y + line), (int)color);
    }

    private static enum ZOOM_LEVEL {
        NORMAL(1.0f, 165, 224, 1, 0),
        LEVEL_1(0.5f, 330, 465, 1, 50),
        LEVEL_2(0.25f, 660, 950, 2, 100);

        final float zoom;
        final int bottomRenderBorder;
        final int rightRenderBorder;
        final int line;
        final int moveY;

        private ZOOM_LEVEL(float zoom, int bottom, int right, int line, int moveY) {
            this.zoom = zoom;
            this.bottomRenderBorder = bottom;
            this.rightRenderBorder = right;
            this.line = line;
            this.moveY = moveY;
        }

        ZOOM_LEVEL next() {
            int id = this.ordinal();
            if (id + 1 >= ZOOM_LEVEL.values().length) {
                return this;
            }
            return ZOOM_LEVEL.values()[id + 1];
        }

        ZOOM_LEVEL prev() {
            int id = this.ordinal();
            if (id - 1 < 0) {
                return this;
            }
            return ZOOM_LEVEL.values()[id - 1];
        }
    }
}

