/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.hud;

import logisticspipes.gui.hud.BasicHUDGui;
import logisticspipes.interfaces.IHUDConfig;
import logisticspipes.pipes.PipeItemsProviderLogistics;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.hud.BasicHUDButton;
import logisticspipes.utils.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class HUDProvider
extends BasicHUDGui {
    private final PipeItemsProviderLogistics pipe;
    private int page = 0;
    private int pageB = 0;

    public HUDProvider(PipeItemsProviderLogistics pipe) {
        this.pipe = pipe;
        this.addButton(new BasicHUDButton("<", -2, -50, 8, 8){

            @Override
            public void clicked() {
                if (HUDProvider.this.page > 0) {
                    HUDProvider.this.page--;
                }
            }

            @Override
            public boolean shouldRenderButton() {
                return true;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDProvider.this.page > 0;
            }
        });
        this.addButton(new BasicHUDButton(">", 37, -50, 8, 8){

            @Override
            public void clicked() {
                if (HUDProvider.this.page + 1 < HUDProvider.this.getMaxPage()) {
                    HUDProvider.this.page++;
                }
            }

            @Override
            public boolean shouldRenderButton() {
                return true;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDProvider.this.page + 1 < HUDProvider.this.getMaxPage();
            }
        });
        this.addButton(new BasicHUDButton("<", -2, 21, 8, 8){

            @Override
            public void clicked() {
                if (HUDProvider.this.pageB > 0) {
                    HUDProvider.this.pageB--;
                }
            }

            @Override
            public boolean shouldRenderButton() {
                return true;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDProvider.this.pageB > 0;
            }
        });
        this.addButton(new BasicHUDButton(">", 37, 21, 8, 8){

            @Override
            public void clicked() {
                if (HUDProvider.this.pageB + 1 < HUDProvider.this.getMaxPageOrderer()) {
                    HUDProvider.this.pageB++;
                }
            }

            @Override
            public boolean shouldRenderButton() {
                return true;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDProvider.this.pageB + 1 < HUDProvider.this.getMaxPageOrderer();
            }
        });
    }

    @Override
    public void renderHeadUpDisplay(double distance, boolean day, boolean shifted, Minecraft mc, IHUDConfig config) {
        if (day) {
            GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)64);
        } else {
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
        }
        GuiGraphics.drawGuiBackGround(mc, -50, -55, 50, 55, 0.0f, false);
        if (day) {
            GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)127);
        } else {
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
        super.renderHeadUpDisplay(distance, day, shifted, mc, config);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.005f);
        float scaleX = 1.125f;
        float scaleY = 1.125f;
        float scaleZ = -1.0E-4f;
        GL11.glScalef((float)scaleX, (float)scaleY, (float)scaleZ);
        ItemStackRenderer itemStackRenderer = new ItemStackRenderer(0, 0, 0.0f, false, shifted, true);
        itemStackRenderer.setDisplayAmount(ItemStackRenderer.DisplayAmount.ALWAYS);
        itemStackRenderer.setScaleX(scaleX).setScaleY(scaleY).setScaleZ(scaleZ);
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(this.pipe.displayList, null, this.page, -36, -37, 4, 12, 18, 18, itemStackRenderer);
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(this.pipe.itemListOrderer, null, this.pageB, -36, 23, 4, 4, 18, 18, itemStackRenderer);
        GL11.glScalef((float)0.875f, (float)0.875f, (float)-1.0f);
        String message = "(" + (this.page + 1) + "/" + this.getMaxPage() + ")";
        mc.field_71466_p.func_78276_b(message, 9, -50, 0);
        message = "(" + (this.pageB + 1) + "/" + this.getMaxPageOrderer() + ")";
        mc.field_71466_p.func_78276_b(message, 9, 23, 0);
    }

    public int getMaxPage() {
        int ret = this.pipe.displayList.size() / 12;
        if (this.pipe.displayList.size() % 12 != 0 || ret == 0) {
            ++ret;
        }
        return ret;
    }

    public int getMaxPageOrderer() {
        int ret = this.pipe.itemListOrderer.size() / 4;
        if (this.pipe.itemListOrderer.size() % 4 != 0 || ret == 0) {
            ++ret;
        }
        return ret;
    }

    @Override
    public boolean display(IHUDConfig config) {
        return this.pipe.displayList.size() > 0 && config.isHUDProvider();
    }

    @Override
    public boolean cursorOnWindow(int x, int y) {
        return -50 < x && x < 50 && -55 < y && y < 55;
    }
}

