/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.crafting;

import java.util.ArrayList;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.blocks.crafting.AutoCraftingInventory;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.block.AutoCraftingGui;
import logisticspipes.network.packets.block.CraftingSetType;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.utils.CraftingUtil;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.PlayerIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class LogisticsCraftingTableTileEntity
extends LogisticsSolidTileEntity
implements IGuiTileEntity,
ISimpleInventoryEventHandler,
IInventory,
IGuiOpenControler {
    public ItemIdentifierInventory inv = new ItemIdentifierInventory(18, "Crafting Resources", 64);
    public ItemIdentifierInventory matrix = new ItemIdentifierInventory(9, "Crafting Matrix", 1);
    public ItemIdentifierInventory resultInv = new ItemIdentifierInventory(1, "Crafting Result", 1);
    public ItemIdentifier targetType = null;
    public DictResource[] fuzzyFlags = new DictResource[9];
    public DictResource outputFuzzyFlags = new DictResource(null, null);
    private IRecipe cache;
    private EntityPlayer fake;
    private PlayerIdentifier placedBy = null;
    private final PlayerCollectionList guiWatcher = new PlayerCollectionList();

    public LogisticsCraftingTableTileEntity() {
        this.matrix.addListener(this);
        for (int i = 0; i < 9; ++i) {
            this.fuzzyFlags[i] = new DictResource(null, null);
        }
    }

    public void cacheRecipe() {
        ItemIdentifier oldTargetType = this.targetType;
        this.cache = null;
        this.resultInv.clearInventorySlotContents(0);
        AutoCraftingInventory craftInv = new AutoCraftingInventory(this.placedBy);
        for (int i = 0; i < 9; ++i) {
            craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
        }
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        for (IRecipe r : CraftingUtil.getRecipeList()) {
            if (!r.func_77569_a((InventoryCrafting)craftInv, this.func_145831_w())) continue;
            list.add(r);
        }
        if (list.size() == 1) {
            this.cache = (IRecipe)list.get(0);
            this.resultInv.func_70299_a(0, this.cache.func_77572_b((InventoryCrafting)craftInv));
            this.targetType = null;
        } else if (list.size() > 1) {
            ItemStack result;
            if (this.targetType != null) {
                for (IRecipe recipe : list) {
                    craftInv = new AutoCraftingInventory(this.placedBy);
                    for (int i = 0; i < 9; ++i) {
                        craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
                    }
                    result = recipe.func_77572_b((InventoryCrafting)craftInv);
                    if (result == null || !this.targetType.equals(ItemIdentifier.get(result))) continue;
                    this.resultInv.func_70299_a(0, result);
                    this.cache = recipe;
                    break;
                }
            }
            if (this.cache == null) {
                for (IRecipe r : list) {
                    result = r.func_77572_b((InventoryCrafting)craftInv);
                    if (result == null) continue;
                    this.cache = r;
                    this.resultInv.func_70299_a(0, result);
                    this.targetType = ItemIdentifier.get(result);
                    break;
                }
            }
        } else {
            this.targetType = null;
        }
        this.outputFuzzyFlags.stack = this.resultInv.getIDStackInSlot(0);
        if ((this.targetType == null && oldTargetType != null || this.targetType != null && !this.targetType.equals(oldTargetType)) && !this.guiWatcher.isEmpty() && this.func_145831_w() != null && MainProxy.isServer(this.func_145831_w())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(CraftingSetType.class).setTargetType(this.targetType).setTilePos(this), this.guiWatcher);
        }
    }

    public void cycleRecipe(boolean down) {
        this.cacheRecipe();
        if (this.targetType == null) {
            return;
        }
        this.cache = null;
        AutoCraftingInventory craftInv = new AutoCraftingInventory(this.placedBy);
        for (int i = 0; i < 9; ++i) {
            craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
        }
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        for (IRecipe r : CraftingUtil.getRecipeList()) {
            if (!r.func_77569_a((InventoryCrafting)craftInv, this.func_145831_w())) continue;
            list.add(r);
        }
        if (list.size() > 1) {
            boolean found = false;
            IRecipe prev = null;
            for (IRecipe recipe : list) {
                if (found) {
                    this.cache = recipe;
                    break;
                }
                craftInv = new AutoCraftingInventory(this.placedBy);
                for (int i = 0; i < 9; ++i) {
                    craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
                }
                if (this.targetType != null && this.targetType.equals(ItemIdentifier.get(recipe.func_77572_b((InventoryCrafting)craftInv)))) {
                    if (down) {
                        found = true;
                    } else {
                        if (prev == null) {
                            this.cache = (IRecipe)list.get(list.size() - 1);
                            break;
                        }
                        this.cache = prev;
                        break;
                    }
                }
                prev = recipe;
            }
            if (this.cache == null) {
                this.cache = (IRecipe)list.get(0);
            }
            craftInv = new AutoCraftingInventory(this.placedBy);
            for (int i = 0; i < 9; ++i) {
                craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
            }
            this.targetType = ItemIdentifier.get(this.cache.func_77572_b((InventoryCrafting)craftInv));
        }
        if (!this.guiWatcher.isEmpty() && this.func_145831_w() != null && MainProxy.isServer(this.func_145831_w())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(CraftingSetType.class).setTargetType(this.targetType).setTilePos(this), this.guiWatcher);
        }
        this.cacheRecipe();
    }

    private boolean testFuzzy(ItemIdentifier item, ItemIdentifierStack item2, int slot) {
        this.fuzzyFlags[slot].stack = item.makeStack(1);
        return this.fuzzyFlags[slot].matches(item2.getItem(), IResource.MatchSettings.NORMAL);
    }

    public ItemStack getOutput(IResource wanted, IRoutedPowerProvider power) {
        ItemStack left;
        int i;
        ItemStack result;
        boolean isFuzzy = this.isFuzzy();
        if (this.cache == null) {
            this.cacheRecipe();
            if (this.cache == null) {
                return null;
            }
        }
        int[] toUse = new int[9];
        int[] used = new int[this.inv.func_70302_i_()];
        block0: for (int i2 = 0; i2 < 9; ++i2) {
            ItemIdentifierStack item = this.matrix.getIDStackInSlot(i2);
            if (item == null) {
                toUse[i2] = -1;
                continue;
            }
            ItemIdentifier ident = item.getItem();
            for (int j = 0; j < this.inv.func_70302_i_(); ++j) {
                item = this.inv.getIDStackInSlot(j);
                if (item == null || !(isFuzzy ? this.testFuzzy(ident, item, i2) : ident.equalsForCrafting(item.getItem())) || item.getStackSize() <= used[j]) continue;
                int n = j;
                used[n] = used[n] + 1;
                toUse[i2] = j;
                continue block0;
            }
            return null;
        }
        AutoCraftingInventory crafter = new AutoCraftingInventory(this.placedBy);
        for (int i3 = 0; i3 < 9; ++i3) {
            int j = toUse[i3];
            if (j == -1) continue;
            crafter.func_70299_a(i3, this.inv.func_70301_a(j));
        }
        IRecipe recipe = this.cache;
        this.outputFuzzyFlags.stack = this.resultInv.getIDStackInSlot(0);
        if (!recipe.func_77569_a((InventoryCrafting)crafter, this.func_145831_w())) {
            if (isFuzzy && this.outputFuzzyFlags.getBitSet().nextSetBit(0) != -1) {
                recipe = null;
                for (IRecipe r : CraftingUtil.getRecipeList()) {
                    if (!r.func_77569_a((InventoryCrafting)crafter, this.func_145831_w()) || !this.outputFuzzyFlags.matches(ItemIdentifier.get(r.func_77571_b()), IResource.MatchSettings.NORMAL)) continue;
                    recipe = r;
                    break;
                }
                if (recipe == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if ((result = recipe.func_77572_b((InventoryCrafting)crafter)) == null) {
            return null;
        }
        if (isFuzzy && this.outputFuzzyFlags.getBitSet().nextSetBit(0) != -1) {
            if (!this.outputFuzzyFlags.matches(ItemIdentifier.get(result), IResource.MatchSettings.NORMAL)) {
                return null;
            }
            if (!this.outputFuzzyFlags.matches(wanted.getAsItem(), IResource.MatchSettings.NORMAL)) {
                return null;
            }
        } else {
            if (!this.resultInv.getIDStackInSlot(0).getItem().equalsWithoutNBT(ItemIdentifier.get(result))) {
                return null;
            }
            if (!wanted.matches(this.resultInv.getIDStackInSlot(0).getItem(), IResource.MatchSettings.WITHOUT_NBT)) {
                return null;
            }
        }
        if (!power.useEnergy(Configs.LOGISTICS_CRAFTING_TABLE_POWER_USAGE)) {
            return null;
        }
        crafter = new AutoCraftingInventory(this.placedBy);
        for (int i4 = 0; i4 < 9; ++i4) {
            int j = toUse[i4];
            if (j == -1) continue;
            crafter.func_70299_a(i4, this.inv.func_70298_a(j, 1));
        }
        result = recipe.func_77572_b((InventoryCrafting)crafter);
        if (this.fake == null) {
            this.fake = MainProxy.getFakePlayer(this);
        }
        result = result.func_77946_l();
        SlotCrafting craftingSlot = new SlotCrafting(this.fake, (IInventory)crafter, (IInventory)this.resultInv, 0, 0, 0);
        craftingSlot.func_82870_a(this.fake, result);
        for (i = 0; i < 9; ++i) {
            left = crafter.func_70301_a(i);
            crafter.func_70299_a(i, null);
            if (left == null) continue;
            left.field_77994_a = this.inv.addCompressed(left, false);
            if (left.field_77994_a <= 0) continue;
            ItemIdentifierInventory.dropItems(this.field_145850_b, left, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        for (i = 0; i < this.fake.field_71071_by.func_70302_i_(); ++i) {
            left = this.fake.field_71071_by.func_70301_a(i);
            this.fake.field_71071_by.func_70299_a(i, null);
            if (left == null) continue;
            left.field_77994_a = this.inv.addCompressed(left, false);
            if (left.field_77994_a <= 0) continue;
            ItemIdentifierInventory.dropItems(this.field_145850_b, left, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return result;
    }

    public void onBlockBreak() {
        this.inv.dropContents(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (inventory == this.matrix) {
            this.cacheRecipe();
        }
    }

    public void handleNEIRecipePacket(ItemStack[] content) {
        for (int i = 0; i < 9; ++i) {
            this.matrix.func_70299_a(i, content[i]);
        }
        this.cacheRecipe();
    }

    @Override
    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.inv.readFromNBT(par1nbtTagCompound, "inv");
        this.matrix.readFromNBT(par1nbtTagCompound, "matrix");
        if (par1nbtTagCompound.func_74764_b("placedBy")) {
            String name = par1nbtTagCompound.func_74779_i("placedBy");
            this.placedBy = PlayerIdentifier.convertFromUsername(name);
        } else {
            this.placedBy = PlayerIdentifier.readFromNBT(par1nbtTagCompound, "placedBy");
        }
        if (par1nbtTagCompound.func_74764_b("fuzzyFlags")) {
            NBTTagList lst = par1nbtTagCompound.func_150295_c("fuzzyFlags", 10);
            for (int i = 0; i < 9; ++i) {
                NBTTagCompound comp = lst.func_150305_b(i);
                this.fuzzyFlags[i].ignore_dmg = comp.func_74767_n("ignore_dmg");
                this.fuzzyFlags[i].ignore_nbt = comp.func_74767_n("ignore_nbt");
                this.fuzzyFlags[i].use_od = comp.func_74767_n("use_od");
                this.fuzzyFlags[i].use_category = comp.func_74767_n("use_category");
            }
        }
        if (par1nbtTagCompound.func_74764_b("outputFuzzyFlags")) {
            NBTTagCompound comp = par1nbtTagCompound.func_74775_l("outputFuzzyFlags");
            this.outputFuzzyFlags.ignore_dmg = comp.func_74767_n("ignore_dmg");
            this.outputFuzzyFlags.ignore_nbt = comp.func_74767_n("ignore_nbt");
            this.outputFuzzyFlags.use_od = comp.func_74767_n("use_od");
            this.outputFuzzyFlags.use_category = comp.func_74767_n("use_category");
        }
        if (par1nbtTagCompound.func_74764_b("targetType")) {
            this.targetType = ItemIdentifier.get(ItemStack.func_77949_a((NBTTagCompound)par1nbtTagCompound.func_74775_l("targetType")));
        }
        this.cacheRecipe();
    }

    @Override
    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        this.inv.writeToNBT(par1nbtTagCompound, "inv");
        this.matrix.writeToNBT(par1nbtTagCompound, "matrix");
        if (this.placedBy != null) {
            this.placedBy.writeToNBT(par1nbtTagCompound, "placedBy");
        }
        NBTTagList lst = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74757_a("ignore_dmg", this.fuzzyFlags[i].ignore_dmg);
            comp.func_74757_a("ignore_nbt", this.fuzzyFlags[i].ignore_nbt);
            comp.func_74757_a("use_od", this.fuzzyFlags[i].use_od);
            comp.func_74757_a("use_category", this.fuzzyFlags[i].use_category);
            lst.func_74742_a((NBTBase)comp);
        }
        par1nbtTagCompound.func_74782_a("fuzzyFlags", (NBTBase)lst);
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74757_a("ignore_dmg", this.outputFuzzyFlags.ignore_dmg);
        comp.func_74757_a("ignore_nbt", this.outputFuzzyFlags.ignore_nbt);
        comp.func_74757_a("use_od", this.outputFuzzyFlags.use_od);
        comp.func_74757_a("use_category", this.outputFuzzyFlags.use_category);
        par1nbtTagCompound.func_74782_a("outputFuzzyFlags", (NBTBase)comp);
        if (this.targetType != null) {
            NBTTagCompound type = new NBTTagCompound();
            this.targetType.makeNormalStack(1).func_77955_b(type);
            par1nbtTagCompound.func_74782_a("targetType", (NBTBase)type);
        } else {
            par1nbtTagCompound.func_82580_o("targetType");
        }
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inv.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.inv.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
    }

    public String func_145825_b() {
        return "LogisticsCraftingTable";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        ItemIdentifierStack stack;
        if (i < 9 && i >= 0 && (stack = this.matrix.getIDStackInSlot(i)) != null && itemstack != null) {
            if (this.isFuzzy() && this.fuzzyFlags[i].getBitSet().nextSetBit(0) != -1) {
                this.fuzzyFlags[i].stack = stack;
                return this.fuzzyFlags[i].matches(ItemIdentifier.get(itemstack), IResource.MatchSettings.NORMAL);
            }
            return stack.getItem().equalsWithoutNBT(ItemIdentifier.get(itemstack));
        }
        return true;
    }

    public void placedBy(EntityLivingBase par5EntityLivingBase) {
        if (par5EntityLivingBase instanceof EntityPlayer) {
            this.placedBy = PlayerIdentifier.get((EntityPlayer)par5EntityLivingBase);
        }
    }

    public boolean isFuzzy() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 4;
    }

    @Override
    public CoordinatesGuiProvider getGuiProvider() {
        return NewGuiHandler.getGui(AutoCraftingGui.class).setCraftingTable(this);
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.guiWatcher.add(player);
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.guiWatcher.remove(player);
    }
}

