/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.builder.UIBuilder;
import com.gtnewhorizons.modularui.common.builder.UIInfo;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularGui;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_OutputBus_ME;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import kubatech.api.Variables;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;

public abstract class KubaTechGTMultiBlockBase<T extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<T>>
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<T> {
    @Deprecated
    public final int mEUt = 0;
    protected final Function<Widget, Boolean> isFixed = widget -> this.getIdealStatus() == this.getRepairStatus() && this.mMachine;
    protected static final Function<Integer, IDrawable> toggleButtonTextureGetter = val -> val == 0 ? GT_UITextures.OVERLAY_BUTTON_CROSS : GT_UITextures.OVERLAY_BUTTON_CHECKMARK;

    protected static <K extends KubaTechGTMultiBlockBase<?>> UIInfo<?, ?> createKTMetaTileEntityUI(KTContainerConstructor<K> containerConstructor) {
        return UIBuilder.of().container((player, world, x, y, z) -> {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof BaseMetaTileEntity) {
                IMetaTileEntity mte = ((BaseMetaTileEntity)te).getMetaTileEntity();
                if (!(mte instanceof KubaTechGTMultiBlockBase)) {
                    return null;
                }
                UIBuildContext buildContext = new UIBuildContext(player);
                ModularWindow window = ((ITileWithModularUI)te).createWindow(buildContext);
                return containerConstructor.of(new ModularUIContext(buildContext, () -> ((TileEntity)te).func_70296_d()), window, (Object)((Object)((KubaTechGTMultiBlockBase)mte)));
            }
            return null;
        }).gui((player, world, x, y, z) -> {
            if (!world.field_72995_K) {
                return null;
            }
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof BaseMetaTileEntity) {
                IMetaTileEntity mte = ((BaseMetaTileEntity)te).getMetaTileEntity();
                if (!(mte instanceof KubaTechGTMultiBlockBase)) {
                    return null;
                }
                UIBuildContext buildContext = new UIBuildContext(player);
                ModularWindow window = ((ITileWithModularUI)te).createWindow(buildContext);
                return new ModularGui(containerConstructor.of(new ModularUIContext(buildContext, null), window, (Object)((Object)((KubaTechGTMultiBlockBase)mte))));
            }
            return null;
        }).build();
    }

    protected KubaTechGTMultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected KubaTechGTMultiBlockBase(String aName) {
        super(aName);
    }

    protected boolean isOverclockingInfinite() {
        return false;
    }

    protected int getOverclockTimeLimit() {
        return 1;
    }

    protected void calculateOverclockedNessMultiInternal(long aEUt, int aDuration, int mAmperage, long maxInputVoltage, boolean perfectOC) {
        this.calculateOverclock(aEUt, aDuration, this.getMaxInputEu(), perfectOC);
    }

    protected int calculateOverclock(long aEUt, int aDuration, long maxInputEU, boolean isPerfect) {
        int minDuration = this.getOverclockTimeLimit();
        int tiers = (int)(Math.log((double)maxInputEU / (double)aEUt) / Variables.ln4);
        if (tiers <= 0) {
            this.lEUt = aEUt;
            this.mMaxProgresstime = aDuration;
            return 0;
        }
        int durationTiers = (int)Math.ceil(Math.log((double)aDuration / (double)minDuration) / (isPerfect ? Variables.ln4 : Variables.ln2));
        if (durationTiers < 0) {
            durationTiers = 0;
        }
        if (durationTiers > tiers) {
            durationTiers = tiers;
        }
        if (!this.isOverclockingInfinite()) {
            tiers = durationTiers;
            if (tiers == 0) {
                this.lEUt = aEUt;
                this.mMaxProgresstime = aDuration;
                return 0;
            }
            this.lEUt = aEUt << (tiers << 1);
            if ((aDuration >>= isPerfect ? tiers << 1 : tiers) < minDuration) {
                aDuration = minDuration;
            }
            this.mMaxProgresstime = aDuration;
            return tiers;
        }
        this.lEUt = aEUt << (tiers << 1);
        aDuration >>= isPerfect ? durationTiers << 1 : durationTiers;
        int dMulti = tiers - durationTiers;
        if (dMulti > 0) {
            dMulti = 1 << (isPerfect ? dMulti << 1 : dMulti);
            for (ItemStack itemStack : this.mOutputItems) {
                itemStack.field_77994_a *= dMulti;
            }
            for (ItemStack itemStack : this.mOutputFluids) {
                itemStack.amount *= dMulti;
            }
        }
        if (aDuration < minDuration) {
            aDuration = minDuration;
        }
        this.mMaxProgresstime = aDuration;
        return tiers;
    }

    protected int calculateOverclock(long aEUt, int aDuration, boolean isPerfect) {
        return this.calculateOverclock(aEUt, aDuration, this.getMaxInputEu(), isPerfect);
    }

    protected int calculateOverclock(long aEUt, int aDuration) {
        return this.calculateOverclock(aEUt, aDuration, false);
    }

    protected int calculatePerfectOverclock(long aEUt, int aDuration) {
        return this.calculateOverclock(aEUt, aDuration, true);
    }

    public int getVoltageTier() {
        return (int)this.getVoltageTierExact();
    }

    public double getVoltageTierExact() {
        return Math.log((double)this.getMaxInputEu() / 8.0) / Variables.ln4 + 1.0E-8;
    }

    protected boolean tryOutputAll(List<ItemStack> list) {
        return this.tryOutputAll(list, l -> Collections.singletonList((ItemStack)l));
    }

    protected boolean tryOutputAll(List<?> list, Function<Object, List<ItemStack>> mappingFunction) {
        if (list == null || list.isEmpty() || mappingFunction == null) {
            return false;
        }
        int emptySlots = 0;
        boolean ignoreEmptiness = false;
        for (GT_MetaTileEntity_Hatch_OutputBus i : this.mOutputBusses) {
            if (i instanceof GT_MetaTileEntity_Hatch_OutputBus_ME) {
                ignoreEmptiness = true;
                break;
            }
            for (int j = 0; j < i.func_70302_i_(); ++j) {
                if (!i.isValidSlot(j) || i.func_70301_a(j) != null) continue;
                ++emptySlots;
            }
        }
        if (emptySlots == 0 && !ignoreEmptiness) {
            return false;
        }
        boolean wasSomethingRemoved = false;
        while (!list.isEmpty()) {
            List<ItemStack> toOutputNow = mappingFunction.apply(list.get(0));
            if (!ignoreEmptiness && emptySlots < toOutputNow.size()) break;
            emptySlots -= toOutputNow.size();
            list.remove(0);
            wasSomethingRemoved = true;
            for (ItemStack stack : toOutputNow) {
                this.addOutput(stack);
            }
        }
        return wasSomethingRemoved;
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected static String voltageTooltipFormatted(int tier) {
        return GT_Values.TIER_COLORS[tier] + GT_Values.VN[tier] + EnumChatFormatting.GRAY;
    }

    @FunctionalInterface
    protected static interface KTContainerConstructor<T extends KubaTechGTMultiBlockBase<?>> {
        public ModularUIContainer of(ModularUIContext var1, ModularWindow var2, T var3);
    }
}

